note
	description: "Defines the interval, in weeks, between invocations of a task. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	X_WEEKLY_RECORD

inherit
	ECOM_STRUCTURE
		redefine
			make
		end

create
	make,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Make.
		do
			Precursor {ECOM_STRUCTURE}
		end

	make_from_pointer (a_pointer: POINTER)
			-- Make from pointer.
		do
			make_by_pointer (a_pointer)
		end

feature -- Access

	weeks_interval: INTEGER
			-- 
		do
			Result := ccom_x_weekly_weeks_interval (item)
		end

	rgf_days_of_the_week: INTEGER
			-- 
		do
			Result := ccom_x_weekly_rgf_days_of_the_week (item)
		end

feature -- Measurement

	structure_size: INTEGER
			-- Size of structure
		do
			Result := c_size_of_x_weekly
		end

feature -- Basic Operations

	set_weeks_interval (a_weeks_interval: INTEGER)
			-- Set `weeks_interval' with `a_weeks_interval'.
		do
			ccom_x_weekly_set_weeks_interval (item, a_weeks_interval)
		end

	set_rgf_days_of_the_week (a_rgf_days_of_the_week: INTEGER)
			-- Set `rgf_days_of_the_week' with `a_rgf_days_of_the_week'.
		do
			ccom_x_weekly_set_rgf_days_of_the_week (item, a_rgf_days_of_the_week)
		end

feature {NONE}  -- Externals

	c_size_of_x_weekly: INTEGER
			-- Size of structure
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__WEEKLY.h%"]"
		alias 
			"sizeof (ecom_MS_TaskSched_lib::_WEEKLY)"
		end

	ccom_x_weekly_weeks_interval (a_pointer: POINTER): INTEGER
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__WEEKLY_impl.h%"](ecom_MS_TaskSched_lib::_WEEKLY *):EIF_INTEGER"
		end

	ccom_x_weekly_set_weeks_interval (a_pointer: POINTER; arg2: INTEGER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__WEEKLY_impl.h%"](ecom_MS_TaskSched_lib::_WEEKLY *, USHORT)"
		end

	ccom_x_weekly_rgf_days_of_the_week (a_pointer: POINTER): INTEGER
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__WEEKLY_impl.h%"](ecom_MS_TaskSched_lib::_WEEKLY *):EIF_REFERENCE"
		end

	ccom_x_weekly_set_rgf_days_of_the_week (a_pointer: POINTER; arg2: INTEGER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__WEEKLY_impl.h%"](ecom_MS_TaskSched_lib::_WEEKLY *, long)"
		end

end -- X_WEEKLY_RECORD


