note
	description: "Object representing output modes."
	date: "$Date$"
	revision: "$Revision$"

once class
	CIL_OUTPUT_MODE
create
	ilasm, peexe, pedll, object

feature {NONE} -- Creation

	ilasm once  end
	peexe once  end
	pedll once  end
	object once  end

feature -- Access

	instances: ITERABLE [CIL_OUTPUT_MODE]
			-- All known Output moes
		once
			Result := <<
					{CIL_OUTPUT_MODE}.ilasm,
					{CIL_OUTPUT_MODE}.peexe,
					{CIL_OUTPUT_MODE}.pedll,
					{CIL_OUTPUT_MODE}.object	>>
		ensure
			instance_free: class
		end

note
	copyright: "Copyright (c) 1984-2025, Eiffel Software"
	license: "GPL version 2 (see http://www.eiffel.com/licensing/gpl.txt)"
	licensing_options: "http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Eiffel Development Environment.
			
			Eiffel Software's Eiffel Development Environment is free
			software; you can redistribute it and/or modify it under
			the terms of the GNU General Public License as published
			by the Free Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).
			
			Eiffel Software's Eiffel Development Environment is
			distributed in the hope that it will be useful, but
			WITHOUT ANY WARRANTY; without even the implied warranty
			of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
			See the GNU General Public License for more details.
			
			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Eiffel Development
			Environment; if not, write to the Free Software Foundation,
			Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
		]"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"
end
