note
	description: "Tester for Key Generation"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2016-12-13 17:26:01 +0000 (Tue, 13 Dec 2016) $"
	revision: "$Revision: 96710 $"

class
	KG_TESTER

inherit
	PRODUCT_INFO

create
	make_test

feature {NONE} -- Initialization

	make_test
			-- Test KG.
		local
			tests_array: ARRAY [STRING]
			i: INTEGER
		do
			display_copyright
			io.put_string ("%N%NThe following tests are available:%N%N")
			tests_array := tests.current_keys
			from
				i := 1
			until
				i > tests_array.count
			loop
				io.put_string (i.out + ":%T" + tests_array.item (i) + "%N")
				i := i + 1
			end
			io.put_string ("%NEnter your choice (1-" + tests_array.count.out + "): ")
			from
				io.read_line
			until
				io.last_string.is_integer and then io.last_string.to_integer > 0 and then io.last_string.to_integer <= tests.count
			loop
				io.put_string ("Invalid entry, please enter a number between 1 and " + tests.count.out + ": ")
				io.read_line
			end
			if attached tests.item (tests_array.item (io.last_string.to_integer)) as l_agent then
				l_agent.call (Void)
			end
		end

feature {NONE} -- Implementation

	test_private_info
			-- Test private info storing.
		local
			pf: KG_PRIVATE_INFO_IMP
			date: DATE
		do
			create pf.initialize (Name, Version)
			io.put_string ("Testing private info storing mechanism...%N")
			display_private_info (pf)
			io.put_string ("%NEnter registration date: ")
			io.read_line
			create date.make_from_string_default (io.last_string)
			io.put_string ("Enter activation key: ")
			io.read_line
			pf.set_key (io.last_string.twin, date)
			display_private_info (pf)
			io.put_string ("Hack it!: ")
			io.read_line
			pf.hack (io.last_string)
			io.put_string ("Hack successful: " + pf.is_consistent.out + "%N")
		rescue
			io.put_string ("%N! Test crashed, might be normal if you tried to hack...%N")
			io.put_string ("retry (y/n)?")
			io.read_line
			if io.last_string.is_equal ("y") then
				retry
			end
		end

	display_private_info (pf: KG_PRIVATE_INFO_IMP)
			-- Display `pf'.
		require
			non_void_info: pf /= Void
		local
			s: STRING
		do
			s := pf.data.twin
			s.keep_head (pf.Checksum_length_index - 1)
			io.put_string ("Data: " + pf.data + "%N")
			io.put_string ("Activation key: " + pf.activation_key + "%N")
			io.put_string ("Checksum: " + pf.checksum (s).out + "%N")
			io.put_string ("Remaining executions: " + pf.remaining_executions.out + "%N")
			io.put_string ("Registration date: " + pf.registration_date.out + "%N")
			io.put_string ("Is consistent: " + pf.is_consistent.out + "%N")
		end

	test_keygen
			-- Test KG.
		local
			keygen: KG_CD_KEY_GENERATOR
			pkeygen: KG_ACTIVATION_KEY_GENERATOR
			i: INTEGER
			cd_keys: ARRAY [STRING]
			s, l_name: STRING
			date: DATE
		do
			create keygen.make (Name, Version)
			io.put_string ("Testing keygen...%N")
			from
				i := 1
				create cd_keys.make_filled ("", 1, 20)
			until
				i > 20
			loop
				cd_keys.put (keygen.cd_key, i)
				io.put_string ("Generated key " + i.out + ": " + cd_keys.item (i) + "%N")
				i := i + 1
			end
			from
				io.put_string ("Enter key ('q' to exit): ")
				io.read_line
			until
				io.last_string.is_equal ("q")
			loop
				io.put_string ("Key " + io.last_string + " is valid: " + keygen.is_valid_cd_key (io.last_string).out + "%N")
				io.put_string ("Enter key ('q' to exit): ")
				io.read_line
			end
			io.put_string ("%NTesting activation code generator...%N")
			io.put_string ("Enter user name: ")
			io.read_line
			l_name := io.last_string.twin
			from
				i := 1
			until
				i > 20
			loop
				create date.make_now
				create pkeygen.make (date, Name, Version, l_name, cd_keys.item (i), (create {KG_ENVIRONMENT_VARIABLES_IMP}).platform)
				io.put_string ("Activation code for " + cd_keys.item (i) + " at " + date.out + ":%N" + pkeygen.activation_key + "%N")
				i := i + 1
			end
			from
				io.put_string ("Enter date ('q' to exit):%N")
				io.read_line
			until
				io.last_string.is_equal ("q")
			loop
				create date.make_from_string_default (io.last_string)
				io.put_string ("Enter CD key: ")
				io.read_line
				s := io.last_string.twin
				io.put_string ("Enter activation key: ")
				io.read_line
				create pkeygen.make (date, Name, Version, l_name, s, (create {KG_ENVIRONMENT_VARIABLES_IMP}).platform)
				io.put_string ("Key " + io.last_string + " is valid: " + pkeygen.is_valid_activation_key (io.last_string).out + "%N")
				io.put_string ("Enter date ('q' to exit):%N")
				io.read_line
			end

		end

	tests: HASH_TABLE [PROCEDURE, STRING]
			-- Table of available tests
		once
			create Result.make (2)
			Result.put (agent test_keygen, "Keys generators test")
			Result.put (agent test_private_info, "Private info test")
		end

	display_copyright
			-- Display copyright notice
		do
			io.put_string ("%NISE Eiffel License Checker ")
			io.put_string (Version)
			io.put_string ("%NCopyright (C) Eiffel Software Inc. All rights reserved.")
			io.put_string ("%N%N")
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_TESTER
