/*
 * Code for class KL_EXECUTION_ENVIRONMENT
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "kl431.h"
#include <eif_system.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1110_11238
static EIF_INTEGER_32 inline_F1110_11238 (EIF_POINTER arg1, EIF_INTEGER_32 arg2)
{
	#ifdef EIF_WINDOWS
	char *exePath;
	if (_get_pgmptr(&exePath) != 0)
		exePath = "";
#elif EIF_OS == EIF_OS_DARWIN
		/* MacOS X < 10.4 */
	char exePath[PATH_MAX];
	uint32_t len = sizeof(exePath);
	if (_NSGetExecutablePath(exePath, &len) != 0) {
		exePath[0] = '\0'; // buffer too small (!)
	} else {
		// resolve symlinks, ., .. if possible
		char *canonicalPath = realpath(exePath, NULL);
		if (canonicalPath != NULL) {
			strncpy(exePath,canonicalPath,len);
			free(canonicalPath);
		}
	}
#elif EIF_OS == EIF_OS_FREEBSD
	char exePath[2048];
	int mib[4];  mib[0] = CTL_KERN;  mib[1] = KERN_PROC;  mib[2] = KERN_PROC_PATHNAME;  mib[3] = -1;
	size_t len = sizeof(exePath);
	if (sysctl(mib, 4, exePath, &len, NULL, 0) != 0)
		exePath[0] = '\0';
#elif defined(EIF_SOLARIS)
	char exePath[PATH_MAX];
	if (realpath(getexecname(), exePath) == NULL)
		exePath[0] = '\0';
#else
		/* Linux */
	char exePath[PATH_MAX];
	size_t len = readlink("/proc/self/exe", exePath, sizeof(exePath));
	if (len == -1 || len == sizeof(exePath))
		len = 0;
	exePath[len] = '\0';
#endif
EIF_INTEGER l_result = strlen(exePath) + 1;
if (l_result <= arg2)
	strcpy(arg1, exePath);
return l_result;
	;
}
#define INLINE_F1110_11238
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {KL_EXECUTION_ENVIRONMENT}.variable_value */
EIF_REFERENCE F1110_11232 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(7);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLR(5,loc2);
	RTLR(6,Result);
	RTLIU(7);
	
	RTGC;
	tr1 = RTOSCF(11237,F1110_11237, (Current));
	tr2 = RTOSCF(9725,F1055_9725, (Current));
	tr2 = F905_7617(RTCW(tr2), arg1);
	tr1 = F313_4946(RTCW(tr1), tr2);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		loc2 = loc1;
		loc2 = RTRV(eif_new_type(1052, 0x01),loc2);
		if (EIF_TEST(loc2)) {
			RTLE;
			return (EIF_REFERENCE) loc2;
		} else {
			tb1 = F1048_9424(loc1);
			if (tb1) {
				tr1 = F1045_9315(loc1);
				RTLE;
				return (EIF_REFERENCE) tr1;
			} else {
				tr1 = RTLNS(eif_new_type(922, 0x01).id, 922, _OBJSIZ_0_0_0_0_0_0_0_0_);
				Result = F923_7819(RTCW(tr1), loc1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {KL_EXECUTION_ENVIRONMENT}.current_executable_pathname */
static EIF_REFERENCE F1110_11234_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(2);
	RTLR(0,loc3);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEV;
	RTGC;
	RTOSP (11234);
#define Result RTOSR(11234)
	RTOC_NEW(Result);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 250L);
	loc3 = RTLNS(eif_new_type(287, 0x01).id, 287, _OBJSIZ_0_1_0_1_0_1_1_0_);
	F288_4504(RTCW(loc3), loc1);
	tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
	loc2 = inline_F1110_11238(tp1, loc1);
	if ((EIF_BOOLEAN) (loc2 > loc1)) {
		loc1 = (EIF_INTEGER_32) loc2;
		F288_4594(RTCW(loc3), loc1);
		tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
		loc2 = inline_F1110_11238(tp1, loc1);
	}
	if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN) (loc2 <= loc1))) {
		tr1 = RTLNS(eif_new_type(1052, 0x01).id, 1052, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
		F1051_9562(RTCW(tr1), tp1);
		Result = (EIF_REFERENCE) tr1;
	} else {
		Result = RTMS_EX_H("",0,0);
	}
	RTOSE (11234);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1110_11234 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(11234,F1110_11234_body,(Current));
}

/* {KL_EXECUTION_ENVIRONMENT}.set_variable_value */
void F1110_11235 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(6);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,arg2);
	RTLR(4,tr3);
	RTLR(5,arg1);
	RTLIU(6);
	
	RTGC;
	tr1 = RTOSCF(11237,F1110_11237, (Current));
	tr2 = RTOSCF(9725,F1055_9725, (Current));
	tr2 = F905_7618(RTCW(tr2), arg2);
	tr3 = RTOSCF(9725,F1055_9725, (Current));
	tr3 = F905_7618(RTCW(tr3), arg1);
	F313_4959(RTCW(tr1), tr2, tr3);
	RTLE;
}

/* {KL_EXECUTION_ENVIRONMENT}.environment_impl */
static EIF_REFERENCE F1110_11237_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (11237);
#define Result RTOSR(11237)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(312, 0x01).id, 312, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (11237);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1110_11237 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(11237,F1110_11237_body,(Current));
}

/* {KL_EXECUTION_ENVIRONMENT}.eif_current_executable_pathname_ptr */
EIF_INTEGER_32 F1110_11238 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F1110_11238 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2);
	return Result;
}

void EIF_Minit431 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
