note
	description: "Task object interface. The primary means of task object manipulation. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

deferred class
	ITASK_INTERFACE

inherit
	ISCHEDULED_WORK_ITEM_INTERFACE

feature -- Basic Operations

	set_application_name (pwsz_application_name: STRING)
			-- Assigns a specific application to the current task.
			-- `pwsz_application_name' [in].  
		deferred

		end

	get_application_name (ppwsz_application_name: CELL [STRING])
			-- Retrieves the name of the application that the task is associated with.
			-- `ppwsz_application_name' [out].  
		require
			attached_ppwsz_application_name: ppwsz_application_name /= Void
		deferred

		ensure
			valid_ppwsz_application_name: ppwsz_application_name.item /= Void
		end

	set_parameters (pwsz_parameters: STRING)
			-- Sets the command-line parameters for the task.
			-- `pwsz_parameters' [in].  
		deferred

		end

	get_parameters (ppwsz_parameters: CELL [STRING])
			-- Retrieves the command-line parameters of a task.
			-- `ppwsz_parameters' [out].  
		require
			attached_ppwsz_parameters: ppwsz_parameters /= Void
		deferred

		ensure
			valid_ppwsz_parameters: ppwsz_parameters.item /= Void
		end

	set_working_directory (pwsz_working_directory: STRING)
			-- Sets the working directory for the task.
			-- `pwsz_working_directory' [in].  
		deferred

		end

	get_working_directory (ppwsz_working_directory: CELL [STRING])
			-- Retrieves the working directory of the task.
			-- `ppwsz_working_directory' [out].  
		require
			attached_ppwsz_working_directory: ppwsz_working_directory /= Void
		deferred

		ensure
			valid_ppwsz_working_directory: ppwsz_working_directory.item /= Void
		end

	set_priority (dw_priority: INTEGER)
			-- Sets the priority for the task.
			-- `dw_priority' [in].  
		deferred

		end

	get_priority (pdw_priority: INTEGER_REF)
			-- Retrieves the priority for the task.
			-- `pdw_priority' [out].  
		require
			attached_pdw_priority: pdw_priority /= Void
		deferred

		end

	set_task_flags (dw_flags: INTEGER)
			-- Sets the flags that modify the behavior of the task.
			-- `dw_flags' [in].  
		deferred

		end

	get_task_flags (pdw_flags: INTEGER_REF)
			-- Returns the flags used to modify the behavior of the task.
			-- `pdw_flags' [out].  
		require
			attached_pdw_flags: pdw_flags /= Void
		deferred

		end

	set_max_run_time (dw_max_run_time_ms: INTEGER)
			-- Sets the maximum length of time the task can run.
			-- `dw_max_run_time_ms' [in].  
		deferred

		end

	get_max_run_time (pdw_max_run_time_ms: INTEGER_REF)
			-- Retrieves the maximum length of time the task can run.
			-- `pdw_max_run_time_ms' [out].  
		require
			attached_pdw_max_run_time_ms: pdw_max_run_time_ms /= Void
		deferred

		end

end -- ITASK_INTERFACE


