/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef _NTDDNDIS_
#define _NTDDNDIS_

#ifdef __cplusplus
extern "C" {
#endif

#define DD_NDIS_DEVICE_NAME "\\Device\\UNKNOWN"

#define _NDIS_CONTROL_CODE(request,method) CTL_CODE(FILE_DEVICE_PHYSICAL_NETCARD,request,method,FILE_ANY_ACCESS)

#define IOCTL_NDIS_QUERY_GLOBAL_STATS _NDIS_CONTROL_CODE(0,METHOD_OUT_DIRECT)
#define IOCTL_NDIS_QUERY_ALL_STATS _NDIS_CONTROL_CODE(1,METHOD_OUT_DIRECT)
#define IOCTL_NDIS_DO_PNP_OPERATION _NDIS_CONTROL_CODE(2,METHOD_BUFFERED)
#define IOCTL_NDIS_QUERY_SELECTED_STATS _NDIS_CONTROL_CODE(3,METHOD_OUT_DIRECT)
#define IOCTL_NDIS_ENUMERATE_INTERFACES _NDIS_CONTROL_CODE(4,METHOD_BUFFERED)
#define IOCTL_NDIS_ADD_TDI_DEVICE _NDIS_CONTROL_CODE(5,METHOD_BUFFERED)
#define IOCTL_NDIS_GET_LOG_DATA _NDIS_CONTROL_CODE(7,METHOD_OUT_DIRECT)
#define IOCTL_NDIS_GET_VERSION _NDIS_CONTROL_CODE(8,METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED7 _NDIS_CONTROL_CODE(0xF,METHOD_OUT_DIRECT)

  typedef ULONG NDIS_OID,*PNDIS_OID;

  typedef UNALIGNED struct _NDIS_STATISTICS_VALUE {
    NDIS_OID Oid;
    ULONG DataLength;
    UCHAR Data[1];
  } NDIS_STATISTICS_VALUE,*PNDIS_STATISTICS_VALUE;

  typedef struct _NDIS_VAR_DATA_DESC {
    USHORT Length;
    USHORT MaximumLength;
    ULONG_PTR Offset;
  } NDIS_VAR_DATA_DESC,*PNDIS_VAR_DATA_DESC;

#include <guiddef.h>

  typedef struct _NDIS_OBJECT_HEADER {
    UCHAR  Type;
    UCHAR  Revision;
    USHORT Size;
  } NDIS_OBJECT_HEADER, *PNDIS_OBJECT_HEADER;

#define OID_GEN_SUPPORTED_LIST 0x00010101
#define OID_GEN_HARDWARE_STATUS 0x00010102
#define OID_GEN_MEDIA_SUPPORTED 0x00010103
#define OID_GEN_MEDIA_IN_USE 0x00010104
#define OID_GEN_MAXIMUM_LOOKAHEAD 0x00010105
#define OID_GEN_MAXIMUM_FRAME_SIZE 0x00010106
#define OID_GEN_LINK_SPEED 0x00010107
#define OID_GEN_TRANSMIT_BUFFER_SPACE 0x00010108
#define OID_GEN_RECEIVE_BUFFER_SPACE 0x00010109
#define OID_GEN_TRANSMIT_BLOCK_SIZE 0x0001010A
#define OID_GEN_RECEIVE_BLOCK_SIZE 0x0001010B
#define OID_GEN_VENDOR_ID 0x0001010C
#define OID_GEN_VENDOR_DESCRIPTION 0x0001010D
#define OID_GEN_CURRENT_PACKET_FILTER 0x0001010E
#define OID_GEN_CURRENT_LOOKAHEAD 0x0001010F
#define OID_GEN_DRIVER_VERSION 0x00010110
#define OID_GEN_MAXIMUM_TOTAL_SIZE 0x00010111
#define OID_GEN_PROTOCOL_OPTIONS 0x00010112
#define OID_GEN_MAC_OPTIONS 0x00010113
#define OID_GEN_MEDIA_CONNECT_STATUS 0x00010114
#define OID_GEN_MAXIMUM_SEND_PACKETS 0x00010115

#define OID_GEN_VENDOR_DRIVER_VERSION 0x00010116
#define OID_GEN_SUPPORTED_GUIDS 0x00010117
#define OID_GEN_NETWORK_LAYER_ADDRESSES 0x00010118
#define OID_GEN_TRANSPORT_HEADER_OFFSET 0x00010119
#define OID_GEN_MACHINE_NAME 0x0001021A
#define OID_GEN_RNDIS_CONFIG_PARAMETER 0x0001021B
#define OID_GEN_VLAN_ID 0x0001021C
#define OID_GEN_MEDIA_CAPABILITIES 0x00010201
#define OID_GEN_PHYSICAL_MEDIUM 0x00010202

#define OID_GEN_XMIT_OK 0x00020101
#define OID_GEN_RCV_OK 0x00020102
#define OID_GEN_XMIT_ERROR 0x00020103
#define OID_GEN_RCV_ERROR 0x00020104
#define OID_GEN_RCV_NO_BUFFER 0x00020105

#define OID_GEN_DIRECTED_BYTES_XMIT 0x00020201
#define OID_GEN_DIRECTED_FRAMES_XMIT 0x00020202
#define OID_GEN_MULTICAST_BYTES_XMIT 0x00020203
#define OID_GEN_MULTICAST_FRAMES_XMIT 0x00020204
#define OID_GEN_BROADCAST_BYTES_XMIT 0x00020205
#define OID_GEN_BROADCAST_FRAMES_XMIT 0x00020206
#define OID_GEN_DIRECTED_BYTES_RCV 0x00020207
#define OID_GEN_DIRECTED_FRAMES_RCV 0x00020208
#define OID_GEN_MULTICAST_BYTES_RCV 0x00020209
#define OID_GEN_MULTICAST_FRAMES_RCV 0x0002020A
#define OID_GEN_BROADCAST_BYTES_RCV 0x0002020B
#define OID_GEN_BROADCAST_FRAMES_RCV 0x0002020C

#define OID_GEN_RCV_CRC_ERROR 0x0002020D
#define OID_GEN_TRANSMIT_QUEUE_LENGTH 0x0002020E

#define OID_GEN_GET_TIME_CAPS 0x0002020F
#define OID_GEN_GET_NETCARD_TIME 0x00020210
#define OID_GEN_NETCARD_LOAD 0x00020211
#define OID_GEN_DEVICE_PROFILE 0x00020212

#define OID_GEN_INIT_TIME_MS 0x00020213
#define OID_GEN_RESET_COUNTS 0x00020214
#define OID_GEN_MEDIA_SENSE_COUNTS 0x00020215
#define OID_GEN_FRIENDLY_NAME 0x00020216
#define OID_GEN_MINIPORT_INFO 0x00020217
#define OID_GEN_RESET_VERIFY_PARAMETERS 0x00020218

#define OID_GEN_CO_SUPPORTED_LIST OID_GEN_SUPPORTED_LIST
#define OID_GEN_CO_HARDWARE_STATUS OID_GEN_HARDWARE_STATUS
#define OID_GEN_CO_MEDIA_SUPPORTED OID_GEN_MEDIA_SUPPORTED
#define OID_GEN_CO_MEDIA_IN_USE OID_GEN_MEDIA_IN_USE
#define OID_GEN_CO_LINK_SPEED OID_GEN_LINK_SPEED
#define OID_GEN_CO_VENDOR_ID OID_GEN_VENDOR_ID
#define OID_GEN_CO_VENDOR_DESCRIPTION OID_GEN_VENDOR_DESCRIPTION
#define OID_GEN_CO_DRIVER_VERSION OID_GEN_DRIVER_VERSION
#define OID_GEN_CO_PROTOCOL_OPTIONS OID_GEN_PROTOCOL_OPTIONS
#define OID_GEN_CO_MAC_OPTIONS OID_GEN_MAC_OPTIONS
#define OID_GEN_CO_MEDIA_CONNECT_STATUS OID_GEN_MEDIA_CONNECT_STATUS
#define OID_GEN_CO_VENDOR_DRIVER_VERSION OID_GEN_VENDOR_DRIVER_VERSION
#define OID_GEN_CO_SUPPORTED_GUIDS OID_GEN_SUPPORTED_GUIDS
#define OID_GEN_CO_GET_TIME_CAPS OID_GEN_GET_TIME_CAPS
#define OID_GEN_CO_GET_NETCARD_TIME OID_GEN_GET_NETCARD_TIME
#define OID_GEN_CO_MINIMUM_LINK_SPEED 0x00020120

#define OID_GEN_CO_XMIT_PDUS_OK OID_GEN_XMIT_OK
#define OID_GEN_CO_RCV_PDUS_OK OID_GEN_RCV_OK
#define OID_GEN_CO_XMIT_PDUS_ERROR OID_GEN_XMIT_ERROR
#define OID_GEN_CO_RCV_PDUS_ERROR OID_GEN_RCV_ERROR
#define OID_GEN_CO_RCV_PDUS_NO_BUFFER OID_GEN_RCV_NO_BUFFER

#define OID_GEN_CO_RCV_CRC_ERROR OID_GEN_RCV_CRC_ERROR
#define OID_GEN_CO_TRANSMIT_QUEUE_LENGTH OID_GEN_TRANSMIT_QUEUE_LENGTH
#define OID_GEN_CO_BYTES_XMIT OID_GEN_DIRECTED_BYTES_XMIT
#define OID_GEN_CO_BYTES_RCV OID_GEN_DIRECTED_BYTES_RCV
#define OID_GEN_CO_NETCARD_LOAD OID_GEN_NETCARD_LOAD
#define OID_GEN_CO_DEVICE_PROFILE OID_GEN_DEVICE_PROFILE
#define OID_GEN_CO_BYTES_XMIT_OUTSTANDING 0x00020221

#define OID_802_3_PERMANENT_ADDRESS 0x01010101
#define OID_802_3_CURRENT_ADDRESS 0x01010102
#define OID_802_3_MULTICAST_LIST 0x01010103
#define OID_802_3_MAXIMUM_LIST_SIZE 0x01010104
#define OID_802_3_MAC_OPTIONS 0x01010105

#define NDIS_802_3_MAC_OPTION_PRIORITY 0x00000001

#define OID_802_3_RCV_ERROR_ALIGNMENT 0x01020101
#define OID_802_3_XMIT_ONE_COLLISION 0x01020102
#define OID_802_3_XMIT_MORE_COLLISIONS 0x01020103

#define OID_802_3_XMIT_DEFERRED 0x01020201
#define OID_802_3_XMIT_MAX_COLLISIONS 0x01020202
#define OID_802_3_RCV_OVERRUN 0x01020203
#define OID_802_3_XMIT_UNDERRUN 0x01020204
#define OID_802_3_XMIT_HEARTBEAT_FAILURE 0x01020205
#define OID_802_3_XMIT_TIMES_CRS_LOST 0x01020206
#define OID_802_3_XMIT_LATE_COLLISIONS 0x01020207

#define OID_802_5_PERMANENT_ADDRESS 0x02010101
#define OID_802_5_CURRENT_ADDRESS 0x02010102
#define OID_802_5_CURRENT_FUNCTIONAL 0x02010103
#define OID_802_5_CURRENT_GROUP 0x02010104
#define OID_802_5_LAST_OPEN_STATUS 0x02010105
#define OID_802_5_CURRENT_RING_STATUS 0x02010106
#define OID_802_5_CURRENT_RING_STATE 0x02010107

#define OID_802_5_LINE_ERRORS 0x02020101
#define OID_802_5_LOST_FRAMES 0x02020102

#define OID_802_5_BURST_ERRORS 0x02020201
#define OID_802_5_AC_ERRORS 0x02020202
#define OID_802_5_ABORT_DELIMETERS 0x02020203
#define OID_802_5_FRAME_COPIED_ERRORS 0x02020204
#define OID_802_5_FREQUENCY_ERRORS 0x02020205
#define OID_802_5_TOKEN_ERRORS 0x02020206
#define OID_802_5_INTERNAL_ERRORS 0x02020207

#define OID_FDDI_LONG_PERMANENT_ADDR 0x03010101
#define OID_FDDI_LONG_CURRENT_ADDR 0x03010102
#define OID_FDDI_LONG_MULTICAST_LIST 0x03010103
#define OID_FDDI_LONG_MAX_LIST_SIZE 0x03010104
#define OID_FDDI_SHORT_PERMANENT_ADDR 0x03010105
#define OID_FDDI_SHORT_CURRENT_ADDR 0x03010106
#define OID_FDDI_SHORT_MULTICAST_LIST 0x03010107
#define OID_FDDI_SHORT_MAX_LIST_SIZE 0x03010108

#define OID_FDDI_ATTACHMENT_TYPE 0x03020101
#define OID_FDDI_UPSTREAM_NODE_LONG 0x03020102
#define OID_FDDI_DOWNSTREAM_NODE_LONG 0x03020103
#define OID_FDDI_FRAME_ERRORS 0x03020104
#define OID_FDDI_FRAMES_LOST 0x03020105
#define OID_FDDI_RING_MGT_STATE 0x03020106
#define OID_FDDI_LCT_FAILURES 0x03020107
#define OID_FDDI_LEM_REJECTS 0x03020108
#define OID_FDDI_LCONNECTION_STATE 0x03020109

#define OID_FDDI_SMT_STATION_ID 0x03030201
#define OID_FDDI_SMT_OP_VERSION_ID 0x03030202
#define OID_FDDI_SMT_HI_VERSION_ID 0x03030203
#define OID_FDDI_SMT_LO_VERSION_ID 0x03030204
#define OID_FDDI_SMT_MANUFACTURER_DATA 0x03030205
#define OID_FDDI_SMT_USER_DATA 0x03030206
#define OID_FDDI_SMT_MIB_VERSION_ID 0x03030207
#define OID_FDDI_SMT_MAC_CT 0x03030208
#define OID_FDDI_SMT_NON_MASTER_CT 0x03030209
#define OID_FDDI_SMT_MASTER_CT 0x0303020A
#define OID_FDDI_SMT_AVAILABLE_PATHS 0x0303020B
#define OID_FDDI_SMT_CONFIG_CAPABILITIES 0x0303020C
#define OID_FDDI_SMT_CONFIG_POLICY 0x0303020D
#define OID_FDDI_SMT_CONNECTION_POLICY 0x0303020E
#define OID_FDDI_SMT_T_NOTIFY 0x0303020F
#define OID_FDDI_SMT_STAT_RPT_POLICY 0x03030210
#define OID_FDDI_SMT_TRACE_MAX_EXPIRATION 0x03030211
#define OID_FDDI_SMT_PORT_INDEXES 0x03030212
#define OID_FDDI_SMT_MAC_INDEXES 0x03030213
#define OID_FDDI_SMT_BYPASS_PRESENT 0x03030214
#define OID_FDDI_SMT_ECM_STATE 0x03030215
#define OID_FDDI_SMT_CF_STATE 0x03030216
#define OID_FDDI_SMT_HOLD_STATE 0x03030217
#define OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG 0x03030218
#define OID_FDDI_SMT_STATION_STATUS 0x03030219
#define OID_FDDI_SMT_PEER_WRAP_FLAG 0x0303021A
#define OID_FDDI_SMT_MSG_TIME_STAMP 0x0303021B
#define OID_FDDI_SMT_TRANSITION_TIME_STAMP 0x0303021C
#define OID_FDDI_SMT_SET_COUNT 0x0303021D
#define OID_FDDI_SMT_LAST_SET_STATION_ID 0x0303021E
#define OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS 0x0303021F
#define OID_FDDI_MAC_BRIDGE_FUNCTIONS 0x03030220
#define OID_FDDI_MAC_T_MAX_CAPABILITY 0x03030221
#define OID_FDDI_MAC_TVX_CAPABILITY 0x03030222
#define OID_FDDI_MAC_AVAILABLE_PATHS 0x03030223
#define OID_FDDI_MAC_CURRENT_PATH 0x03030224
#define OID_FDDI_MAC_UPSTREAM_NBR 0x03030225
#define OID_FDDI_MAC_DOWNSTREAM_NBR 0x03030226
#define OID_FDDI_MAC_OLD_UPSTREAM_NBR 0x03030227
#define OID_FDDI_MAC_OLD_DOWNSTREAM_NBR 0x03030228
#define OID_FDDI_MAC_DUP_ADDRESS_TEST 0x03030229
#define OID_FDDI_MAC_REQUESTED_PATHS 0x0303022A
#define OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE 0x0303022B
#define OID_FDDI_MAC_INDEX 0x0303022C
#define OID_FDDI_MAC_SMT_ADDRESS 0x0303022D
#define OID_FDDI_MAC_LONG_GRP_ADDRESS 0x0303022E
#define OID_FDDI_MAC_SHORT_GRP_ADDRESS 0x0303022F
#define OID_FDDI_MAC_T_REQ 0x03030230
#define OID_FDDI_MAC_T_NEG 0x03030231
#define OID_FDDI_MAC_T_MAX 0x03030232
#define OID_FDDI_MAC_TVX_VALUE 0x03030233
#define OID_FDDI_MAC_T_PRI0 0x03030234
#define OID_FDDI_MAC_T_PRI1 0x03030235
#define OID_FDDI_MAC_T_PRI2 0x03030236
#define OID_FDDI_MAC_T_PRI3 0x03030237
#define OID_FDDI_MAC_T_PRI4 0x03030238
#define OID_FDDI_MAC_T_PRI5 0x03030239
#define OID_FDDI_MAC_T_PRI6 0x0303023A
#define OID_FDDI_MAC_FRAME_CT 0x0303023B
#define OID_FDDI_MAC_COPIED_CT 0x0303023C
#define OID_FDDI_MAC_TRANSMIT_CT 0x0303023D
#define OID_FDDI_MAC_TOKEN_CT 0x0303023E
#define OID_FDDI_MAC_ERROR_CT 0x0303023F
#define OID_FDDI_MAC_LOST_CT 0x03030240
#define OID_FDDI_MAC_TVX_EXPIRED_CT 0x03030241
#define OID_FDDI_MAC_NOT_COPIED_CT 0x03030242
#define OID_FDDI_MAC_LATE_CT 0x03030243
#define OID_FDDI_MAC_RING_OP_CT 0x03030244
#define OID_FDDI_MAC_FRAME_ERROR_THRESHOLD 0x03030245
#define OID_FDDI_MAC_FRAME_ERROR_RATIO 0x03030246
#define OID_FDDI_MAC_NOT_COPIED_THRESHOLD 0x03030247
#define OID_FDDI_MAC_NOT_COPIED_RATIO 0x03030248
#define OID_FDDI_MAC_RMT_STATE 0x03030249
#define OID_FDDI_MAC_DA_FLAG 0x0303024A
#define OID_FDDI_MAC_UNDA_FLAG 0x0303024B
#define OID_FDDI_MAC_FRAME_ERROR_FLAG 0x0303024C
#define OID_FDDI_MAC_NOT_COPIED_FLAG 0x0303024D
#define OID_FDDI_MAC_MA_UNITDATA_AVAILABLE 0x0303024E
#define OID_FDDI_MAC_HARDWARE_PRESENT 0x0303024F
#define OID_FDDI_MAC_MA_UNITDATA_ENABLE 0x03030250
#define OID_FDDI_PATH_INDEX 0x03030251
#define OID_FDDI_PATH_RING_LATENCY 0x03030252
#define OID_FDDI_PATH_TRACE_STATUS 0x03030253
#define OID_FDDI_PATH_SBA_PAYLOAD 0x03030254
#define OID_FDDI_PATH_SBA_OVERHEAD 0x03030255
#define OID_FDDI_PATH_CONFIGURATION 0x03030256
#define OID_FDDI_PATH_T_R_MODE 0x03030257
#define OID_FDDI_PATH_SBA_AVAILABLE 0x03030258
#define OID_FDDI_PATH_TVX_LOWER_BOUND 0x03030259
#define OID_FDDI_PATH_T_MAX_LOWER_BOUND 0x0303025A
#define OID_FDDI_PATH_MAX_T_REQ 0x0303025B
#define OID_FDDI_PORT_MY_TYPE 0x0303025C
#define OID_FDDI_PORT_NEIGHBOR_TYPE 0x0303025D
#define OID_FDDI_PORT_CONNECTION_POLICIES 0x0303025E
#define OID_FDDI_PORT_MAC_INDICATED 0x0303025F
#define OID_FDDI_PORT_CURRENT_PATH 0x03030260
#define OID_FDDI_PORT_REQUESTED_PATHS 0x03030261
#define OID_FDDI_PORT_MAC_PLACEMENT 0x03030262
#define OID_FDDI_PORT_AVAILABLE_PATHS 0x03030263
#define OID_FDDI_PORT_MAC_LOOP_TIME 0x03030264
#define OID_FDDI_PORT_PMD_CLASS 0x03030265
#define OID_FDDI_PORT_CONNECTION_CAPABILITIES 0x03030266
#define OID_FDDI_PORT_INDEX 0x03030267
#define OID_FDDI_PORT_MAINT_LS 0x03030268
#define OID_FDDI_PORT_BS_FLAG 0x03030269
#define OID_FDDI_PORT_PC_LS 0x0303026A
#define OID_FDDI_PORT_EB_ERROR_CT 0x0303026B
#define OID_FDDI_PORT_LCT_FAIL_CT 0x0303026C
#define OID_FDDI_PORT_LER_ESTIMATE 0x0303026D
#define OID_FDDI_PORT_LEM_REJECT_CT 0x0303026E
#define OID_FDDI_PORT_LEM_CT 0x0303026F
#define OID_FDDI_PORT_LER_CUTOFF 0x03030270
#define OID_FDDI_PORT_LER_ALARM 0x03030271
#define OID_FDDI_PORT_CONNNECT_STATE 0x03030272
#define OID_FDDI_PORT_PCM_STATE 0x03030273
#define OID_FDDI_PORT_PC_WITHHOLD 0x03030274
#define OID_FDDI_PORT_LER_FLAG 0x03030275
#define OID_FDDI_PORT_HARDWARE_PRESENT 0x03030276
#define OID_FDDI_SMT_STATION_ACTION 0x03030277
#define OID_FDDI_PORT_ACTION 0x03030278
#define OID_FDDI_IF_DESCR 0x03030279
#define OID_FDDI_IF_TYPE 0x0303027A
#define OID_FDDI_IF_MTU 0x0303027B
#define OID_FDDI_IF_SPEED 0x0303027C
#define OID_FDDI_IF_PHYS_ADDRESS 0x0303027D
#define OID_FDDI_IF_ADMIN_STATUS 0x0303027E
#define OID_FDDI_IF_OPER_STATUS 0x0303027F
#define OID_FDDI_IF_LAST_CHANGE 0x03030280
#define OID_FDDI_IF_IN_OCTETS 0x03030281
#define OID_FDDI_IF_IN_UCAST_PKTS 0x03030282
#define OID_FDDI_IF_IN_NUCAST_PKTS 0x03030283
#define OID_FDDI_IF_IN_DISCARDS 0x03030284
#define OID_FDDI_IF_IN_ERRORS 0x03030285
#define OID_FDDI_IF_IN_UNKNOWN_PROTOS 0x03030286
#define OID_FDDI_IF_OUT_OCTETS 0x03030287
#define OID_FDDI_IF_OUT_UCAST_PKTS 0x03030288
#define OID_FDDI_IF_OUT_NUCAST_PKTS 0x03030289
#define OID_FDDI_IF_OUT_DISCARDS 0x0303028A
#define OID_FDDI_IF_OUT_ERRORS 0x0303028B
#define OID_FDDI_IF_OUT_QLEN 0x0303028C
#define OID_FDDI_IF_SPECIFIC 0x0303028D

#define OID_WAN_PERMANENT_ADDRESS 0x04010101
#define OID_WAN_CURRENT_ADDRESS 0x04010102
#define OID_WAN_QUALITY_OF_SERVICE 0x04010103
#define OID_WAN_PROTOCOL_TYPE 0x04010104
#define OID_WAN_MEDIUM_SUBTYPE 0x04010105
#define OID_WAN_HEADER_FORMAT 0x04010106

#define OID_WAN_GET_INFO 0x04010107
#define OID_WAN_SET_LINK_INFO 0x04010108
#define OID_WAN_GET_LINK_INFO 0x04010109

#define OID_WAN_LINE_COUNT 0x0401010A
#define OID_WAN_PROTOCOL_CAPS 0x0401010B

#define OID_WAN_GET_BRIDGE_INFO 0x0401020A
#define OID_WAN_SET_BRIDGE_INFO 0x0401020B
#define OID_WAN_GET_COMP_INFO 0x0401020C
#define OID_WAN_SET_COMP_INFO 0x0401020D
#define OID_WAN_GET_STATS_INFO 0x0401020E

#define OID_WAN_CO_GET_INFO 0x04010180
#define OID_WAN_CO_SET_LINK_INFO 0x04010181
#define OID_WAN_CO_GET_LINK_INFO 0x04010182
#define OID_WAN_CO_GET_COMP_INFO 0x04010280
#define OID_WAN_CO_SET_COMP_INFO 0x04010281
#define OID_WAN_CO_GET_STATS_INFO 0x04010282

#define OID_LTALK_CURRENT_NODE_ID 0x05010102

#define OID_LTALK_IN_BROADCASTS 0x05020101
#define OID_LTALK_IN_LENGTH_ERRORS 0x05020102

#define OID_LTALK_OUT_NO_HANDLERS 0x05020201
#define OID_LTALK_COLLISIONS 0x05020202
#define OID_LTALK_DEFERS 0x05020203
#define OID_LTALK_NO_DATA_ERRORS 0x05020204
#define OID_LTALK_RANDOM_CTS_ERRORS 0x05020205
#define OID_LTALK_FCS_ERRORS 0x05020206

#define OID_ARCNET_PERMANENT_ADDRESS 0x06010101
#define OID_ARCNET_CURRENT_ADDRESS 0x06010102

#define OID_ARCNET_RECONFIGURATIONS 0x06020201

#define OID_TAPI_ACCEPT 0x07030101
#define OID_TAPI_ANSWER 0x07030102
#define OID_TAPI_CLOSE 0x07030103
#define OID_TAPI_CLOSE_CALL 0x07030104
#define OID_TAPI_CONDITIONAL_MEDIA_DETECTION 0x07030105
#define OID_TAPI_CONFIG_DIALOG 0x07030106
#define OID_TAPI_DEV_SPECIFIC 0x07030107
#define OID_TAPI_DIAL 0x07030108
#define OID_TAPI_DROP 0x07030109
#define OID_TAPI_GET_ADDRESS_CAPS 0x0703010A
#define OID_TAPI_GET_ADDRESS_ID 0x0703010B
#define OID_TAPI_GET_ADDRESS_STATUS 0x0703010C
#define OID_TAPI_GET_CALL_ADDRESS_ID 0x0703010D
#define OID_TAPI_GET_CALL_INFO 0x0703010E
#define OID_TAPI_GET_CALL_STATUS 0x0703010F
#define OID_TAPI_GET_DEV_CAPS 0x07030110
#define OID_TAPI_GET_DEV_CONFIG 0x07030111
#define OID_TAPI_GET_EXTENSION_ID 0x07030112
#define OID_TAPI_GET_ID 0x07030113
#define OID_TAPI_GET_LINE_DEV_STATUS 0x07030114
#define OID_TAPI_MAKE_CALL 0x07030115
#define OID_TAPI_NEGOTIATE_EXT_VERSION 0x07030116
#define OID_TAPI_OPEN 0x07030117
#define OID_TAPI_PROVIDER_INITIALIZE 0x07030118
#define OID_TAPI_PROVIDER_SHUTDOWN 0x07030119
#define OID_TAPI_SECURE_CALL 0x0703011A
#define OID_TAPI_SELECT_EXT_VERSION 0x0703011B
#define OID_TAPI_SEND_USER_USER_INFO 0x0703011C
#define OID_TAPI_SET_APP_SPECIFIC 0x0703011D
#define OID_TAPI_SET_CALL_PARAMS 0x0703011E
#define OID_TAPI_SET_DEFAULT_MEDIA_DETECTION 0x0703011F
#define OID_TAPI_SET_DEV_CONFIG 0x07030120
#define OID_TAPI_SET_MEDIA_MODE 0x07030121
#define OID_TAPI_SET_STATUS_MESSAGES 0x07030122
#define OID_TAPI_GATHER_DIGITS 0x07030123
#define OID_TAPI_MONITOR_DIGITS 0x07030124

#define OID_ATM_SUPPORTED_VC_RATES 0x08010101
#define OID_ATM_SUPPORTED_SERVICE_CATEGORY 0x08010102
#define OID_ATM_SUPPORTED_AAL_TYPES 0x08010103
#define OID_ATM_HW_CURRENT_ADDRESS 0x08010104
#define OID_ATM_MAX_ACTIVE_VCS 0x08010105
#define OID_ATM_MAX_ACTIVE_VCI_BITS 0x08010106
#define OID_ATM_MAX_ACTIVE_VPI_BITS 0x08010107
#define OID_ATM_MAX_AAL0_PACKET_SIZE 0x08010108
#define OID_ATM_MAX_AAL1_PACKET_SIZE 0x08010109
#define OID_ATM_MAX_AAL34_PACKET_SIZE 0x0801010A
#define OID_ATM_MAX_AAL5_PACKET_SIZE 0x0801010B

#define OID_ATM_SIGNALING_VPIVCI 0x08010201
#define OID_ATM_ASSIGNED_VPI 0x08010202
#define OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES 0x08010203
#define OID_ATM_RELEASE_ACCESS_NET_RESOURCES 0x08010204
#define OID_ATM_ILMI_VPIVCI 0x08010205
#define OID_ATM_DIGITAL_BROADCAST_VPIVCI 0x08010206
#define OID_ATM_GET_NEAREST_FLOW 0x08010207
#define OID_ATM_ALIGNMENT_REQUIRED 0x08010208
#define OID_ATM_LECS_ADDRESS 0x08010209
#define OID_ATM_SERVICE_ADDRESS 0x0801020A

#define OID_ATM_CALL_PROCEEDING 0x0801020B
#define OID_ATM_CALL_ALERTING 0x0801020C
#define OID_ATM_PARTY_ALERTING 0x0801020D
#define OID_ATM_CALL_NOTIFY 0x0801020E

#define OID_ATM_MY_IP_NM_ADDRESS 0x0801020F

#define OID_ATM_RCV_CELLS_OK 0x08020101
#define OID_ATM_XMIT_CELLS_OK 0x08020102
#define OID_ATM_RCV_CELLS_DROPPED 0x08020103

#define OID_ATM_RCV_INVALID_VPI_VCI 0x08020201
#define OID_ATM_CELLS_HEC_ERROR 0x08020202
#define OID_ATM_RCV_REASSEMBLY_ERROR 0x08020203

#define OID_WW_GEN_NETWORK_TYPES_SUPPORTED 0x09010101
#define OID_WW_GEN_NETWORK_TYPE_IN_USE 0x09010102
#define OID_WW_GEN_HEADER_FORMATS_SUPPORTED 0x09010103
#define OID_WW_GEN_HEADER_FORMAT_IN_USE 0x09010104
#define OID_WW_GEN_INDICATION_REQUEST 0x09010105
#define OID_WW_GEN_DEVICE_INFO 0x09010106
#define OID_WW_GEN_OPERATION_MODE 0x09010107
#define OID_WW_GEN_LOCK_STATUS 0x09010108
#define OID_WW_GEN_DISABLE_TRANSMITTER 0x09010109
#define OID_WW_GEN_NETWORK_ID 0x0901010A
#define OID_WW_GEN_PERMANENT_ADDRESS 0x0901010B
#define OID_WW_GEN_CURRENT_ADDRESS 0x0901010C
#define OID_WW_GEN_SUSPEND_DRIVER 0x0901010D
#define OID_WW_GEN_BASESTATION_ID 0x0901010E
#define OID_WW_GEN_CHANNEL_ID 0x0901010F
#define OID_WW_GEN_ENCRYPTION_SUPPORTED 0x09010110
#define OID_WW_GEN_ENCRYPTION_IN_USE 0x09010111
#define OID_WW_GEN_ENCRYPTION_STATE 0x09010112
#define OID_WW_GEN_CHANNEL_QUALITY 0x09010113
#define OID_WW_GEN_REGISTRATION_STATUS 0x09010114
#define OID_WW_GEN_RADIO_LINK_SPEED 0x09010115
#define OID_WW_GEN_LATENCY 0x09010116
#define OID_WW_GEN_BATTERY_LEVEL 0x09010117
#define OID_WW_GEN_EXTERNAL_POWER 0x09010118

#define OID_WW_GEN_PING_ADDRESS 0x09010201
#define OID_WW_GEN_RSSI 0x09010202
#define OID_WW_GEN_SIM_STATUS 0x09010203
#define OID_WW_GEN_ENABLE_SIM_PIN 0x09010204
#define OID_WW_GEN_CHANGE_SIM_PIN 0x09010205
#define OID_WW_GEN_SIM_PUK 0x09010206
#define OID_WW_GEN_SIM_EXCEPTION 0x09010207

#define OID_WW_MBX_SUBADDR 0x09050101

#define OID_WW_MBX_FLEXLIST 0x09050103
#define OID_WW_MBX_GROUPLIST 0x09050104
#define OID_WW_MBX_TRAFFIC_AREA 0x09050105
#define OID_WW_MBX_LIVE_DIE 0x09050106
#define OID_WW_MBX_TEMP_DEFAULTLIST 0x09050107

#define OID_WW_PIN_LOC_AUTHORIZE 0x09090101
#define OID_WW_PIN_LAST_LOCATION 0x09090102
#define OID_WW_PIN_LOC_FIX 0x09090103

#define OID_WW_CDPD_SPNI 0x090D0101
#define OID_WW_CDPD_WASI 0x090D0102
#define OID_WW_CDPD_AREA_COLOR 0x090D0103
#define OID_WW_CDPD_TX_POWER_LEVEL 0x090D0104
#define OID_WW_CDPD_EID 0x090D0105
#define OID_WW_CDPD_HEADER_COMPRESSION 0x090D0106
#define OID_WW_CDPD_DATA_COMPRESSION 0x090D0107
#define OID_WW_CDPD_CHANNEL_SELECT 0x090D0108
#define OID_WW_CDPD_CHANNEL_STATE 0x090D0109
#define OID_WW_CDPD_NEI 0x090D010A
#define OID_WW_CDPD_NEI_STATE 0x090D010B
#define OID_WW_CDPD_SERVICE_PROVIDER_IDENTIFIER 0x090D010C
#define OID_WW_CDPD_SLEEP_MODE 0x090D010D

#define OID_WW_CDPD_CIRCUIT_SWITCHED 0x090D010E

#define OID_WW_CDPD_TEI 0x090D010F
#define OID_WW_CDPD_RSSI 0x090D0110

#define OID_WW_CDPD_CS_SERVICE_PREFERENCE 0x090D0111
#define OID_WW_CDPD_CS_SERVICE_STATUS 0x090D0112
#define OID_WW_CDPD_CS_INFO 0x090D0113
#define OID_WW_CDPD_CS_SUSPEND 0x090D0114
#define OID_WW_CDPD_CS_DEFAULT_DIAL_CODE 0x090D0115
#define OID_WW_CDPD_CS_CALLBACK 0x090D0116
#define OID_WW_CDPD_CS_SID_LIST 0x090D0117
#define OID_WW_CDPD_CS_CONFIGURATION 0x090D0118

#define OID_WW_ARD_SNDCP 0x09110101
#define OID_WW_ARD_TMLY_MSG 0x09110102
#define OID_WW_ARD_DATAGRAM 0x09110103

#define OID_WW_TAC_COMPRESSION 0x09150101

#define OID_WW_TAC_SET_CONFIG 0x09150102
#define OID_WW_TAC_GET_STATUS 0x09150103
#define OID_WW_TAC_USER_HEADER 0x09150104

#define OID_WW_TAC_UNIQUE_SDU_TAG 0x09150105
#define OID_WW_TAC_SEND_COMMAND 0x09150106
#define OID_WW_TAC_GET_RESPONSE 0x09150107
#define OID_WW_TAC_DISABLE_RECEIVER 0x09150108
#define OID_WW_TAC_ANTENNA_MODE 0x09150109
#define OID_WW_TAC_FLUSH_DATA 0x0915010A
#define OID_WW_TAC_SHUTDOWN_DEVICE 0x0915010B
#define OID_WW_TAC_DEVICE_EXCEPTION 0x0915010C
#define OID_WW_TAC_RECEIVE_EXCEPTION 0x0915010D
#define OID_WW_TAC_BUFFER_EXCEPTION 0x0915010E
#define OID_WW_TAC_BATTERY_EXCEPTION 0x0915010F
#define OID_WW_TAC_TRANSMITTER_KEYED 0x09150110
#define OID_WW_TAC_SYSTEM_TABLE 0x09150111
#define OID_WW_TAC_CHANNEL_TABLE 0x09150112
#define OID_WW_TAC_DCHANNEL_TABLE 0x09150113
#define OID_WW_TAC_RECEIVE_QUEUE_COUNT 0x09150114

#define OID_WW_TAC_STATISTICS 0x09160101

#define OID_WW_MET_FUNCTION 0x09190101

#define OID_802_11_BSSID 0x0D010101
#define OID_802_11_SSID 0x0D010102
#define OID_802_11_NETWORK_TYPES_SUPPORTED 0x0D010203
#define OID_802_11_NETWORK_TYPE_IN_USE 0x0D010204
#define OID_802_11_TX_POWER_LEVEL 0x0D010205
#define OID_802_11_RSSI 0x0D010206
#define OID_802_11_RSSI_TRIGGER 0x0D010207
#define OID_802_11_INFRASTRUCTURE_MODE 0x0D010108
#define OID_802_11_FRAGMENTATION_THRESHOLD 0x0D010209
#define OID_802_11_RTS_THRESHOLD 0x0D01020A
#define OID_802_11_NUMBER_OF_ANTENNAS 0x0D01020B
#define OID_802_11_RX_ANTENNA_SELECTED 0x0D01020C
#define OID_802_11_TX_ANTENNA_SELECTED 0x0D01020D
#define OID_802_11_SUPPORTED_RATES 0x0D01020E
#define OID_802_11_DESIRED_RATES 0x0D010210
#define OID_802_11_CONFIGURATION 0x0D010211
#define OID_802_11_STATISTICS 0x0D020212
#define OID_802_11_ADD_WEP 0x0D010113
#define OID_802_11_REMOVE_WEP 0x0D010114
#define OID_802_11_DISASSOCIATE 0x0D010115
#define OID_802_11_POWER_MODE 0x0D010216
#define OID_802_11_BSSID_LIST 0x0D010217
#define OID_802_11_AUTHENTICATION_MODE 0x0D010118
#define OID_802_11_PRIVACY_FILTER 0x0D010119
#define OID_802_11_BSSID_LIST_SCAN 0x0D01011A
#define OID_802_11_WEP_STATUS 0x0D01011B

#define OID_802_11_ENCRYPTION_STATUS OID_802_11_WEP_STATUS
#define OID_802_11_RELOAD_DEFAULTS 0x0D01011C

#define OID_802_11_ADD_KEY 0x0D01011D
#define OID_802_11_REMOVE_KEY 0x0D01011E
#define OID_802_11_ASSOCIATION_INFORMATION 0x0D01011F
#define OID_802_11_TEST 0x0D010120
#define OID_802_11_MEDIA_STREAM_MODE 0x0D010121

#define NDIS_802_11_LENGTH_SSID 32
#define NDIS_802_11_LENGTH_RATES 8
#define NDIS_802_11_LENGTH_RATES_EX 16

  typedef enum _NDIS_802_11_STATUS_TYPE {
    Ndis802_11StatusType_Authentication,Ndis802_11StatusType_MediaStreamMode,Ndis802_11StatusTypeMax
  } NDIS_802_11_STATUS_TYPE,*PNDIS_802_11_STATUS_TYPE;

  typedef UCHAR NDIS_802_11_MAC_ADDRESS[6];

  typedef struct _NDIS_802_11_STATUS_INDICATION {
    NDIS_802_11_STATUS_TYPE StatusType;
  } NDIS_802_11_STATUS_INDICATION,*PNDIS_802_11_STATUS_INDICATION;

#define NDIS_802_11_AUTH_REQUEST_AUTH_FIELDS 0x0f
#define NDIS_802_11_AUTH_REQUEST_REAUTH 0x01
#define NDIS_802_11_AUTH_REQUEST_KEYUPDATE 0x02
#define NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR 0x06
#define NDIS_802_11_AUTH_REQUEST_GROUP_ERROR 0x0E

  typedef struct _NDIS_802_11_AUTHENTICATION_REQUEST {
    ULONG Length;
    NDIS_802_11_MAC_ADDRESS Bssid;
    ULONG Flags;
  } NDIS_802_11_AUTHENTICATION_REQUEST,*PNDIS_802_11_AUTHENTICATION_REQUEST;

  typedef enum _NDIS_802_11_NETWORK_TYPE {
    Ndis802_11FH,Ndis802_11DS,Ndis802_11OFDM5,Ndis802_11OFDM24,Ndis802_11Automode,Ndis802_11NetworkTypeMax
  } NDIS_802_11_NETWORK_TYPE,*PNDIS_802_11_NETWORK_TYPE;

  typedef struct _NDIS_802_11_NETWORK_TYPE_LIST {
    ULONG NumberOfItems;
    NDIS_802_11_NETWORK_TYPE NetworkType [1];
  } NDIS_802_11_NETWORK_TYPE_LIST,*PNDIS_802_11_NETWORK_TYPE_LIST;

  typedef enum _NDIS_802_11_POWER_MODE {
    Ndis802_11PowerModeCAM,Ndis802_11PowerModeMAX_PSP,Ndis802_11PowerModeFast_PSP,Ndis802_11PowerModeMax
  } NDIS_802_11_POWER_MODE,*PNDIS_802_11_POWER_MODE;

  typedef ULONG NDIS_802_11_TX_POWER_LEVEL;
  typedef LONG NDIS_802_11_RSSI;

  typedef struct _NDIS_802_11_CONFIGURATION_FH {
    ULONG Length;
    ULONG HopPattern;
    ULONG HopSet;
    ULONG DwellTime;
  } NDIS_802_11_CONFIGURATION_FH,*PNDIS_802_11_CONFIGURATION_FH;

  typedef struct _NDIS_802_11_CONFIGURATION {
    ULONG Length;
    ULONG BeaconPeriod;
    ULONG ATIMWindow;
    ULONG DSConfig;
    NDIS_802_11_CONFIGURATION_FH FHConfig;
  } NDIS_802_11_CONFIGURATION,*PNDIS_802_11_CONFIGURATION;

  typedef struct _NDIS_802_11_STATISTICS {
    ULONG Length;
    LARGE_INTEGER TransmittedFragmentCount;
    LARGE_INTEGER MulticastTransmittedFrameCount;
    LARGE_INTEGER FailedCount;
    LARGE_INTEGER RetryCount;
    LARGE_INTEGER MultipleRetryCount;
    LARGE_INTEGER RTSSuccessCount;
    LARGE_INTEGER RTSFailureCount;
    LARGE_INTEGER ACKFailureCount;
    LARGE_INTEGER FrameDuplicateCount;
    LARGE_INTEGER ReceivedFragmentCount;
    LARGE_INTEGER MulticastReceivedFrameCount;
    LARGE_INTEGER FCSErrorCount;
  } NDIS_802_11_STATISTICS,*PNDIS_802_11_STATISTICS;

  typedef ULONG NDIS_802_11_KEY_INDEX;
  typedef ULONGLONG NDIS_802_11_KEY_RSC;

  typedef struct _NDIS_802_11_KEY {
    ULONG Length;
    ULONG KeyIndex;
    ULONG KeyLength;
    NDIS_802_11_MAC_ADDRESS BSSID;
    NDIS_802_11_KEY_RSC KeyRSC;
    UCHAR KeyMaterial[1];
  } NDIS_802_11_KEY,*PNDIS_802_11_KEY;

  typedef struct _NDIS_802_11_REMOVE_KEY {
    ULONG Length;
    ULONG KeyIndex;
    NDIS_802_11_MAC_ADDRESS BSSID;
  } NDIS_802_11_REMOVE_KEY,*PNDIS_802_11_REMOVE_KEY;

  typedef struct _NDIS_802_11_WEP {
    ULONG Length;
    ULONG KeyIndex;
    ULONG KeyLength;
    UCHAR KeyMaterial[1];
  } NDIS_802_11_WEP,*PNDIS_802_11_WEP;

  typedef enum _NDIS_802_11_NETWORK_INFRASTRUCTURE {
    Ndis802_11IBSS,Ndis802_11Infrastructure,Ndis802_11AutoUnknown,Ndis802_11InfrastructureMax
  } NDIS_802_11_NETWORK_INFRASTRUCTURE,*PNDIS_802_11_NETWORK_INFRASTRUCTURE;

  typedef enum _NDIS_802_11_AUTHENTICATION_MODE {
    Ndis802_11AuthModeOpen,Ndis802_11AuthModeShared,Ndis802_11AuthModeAutoSwitch,Ndis802_11AuthModeWPA,Ndis802_11AuthModeWPAPSK,
    Ndis802_11AuthModeWPANone,Ndis802_11AuthModeMax
  } NDIS_802_11_AUTHENTICATION_MODE,*PNDIS_802_11_AUTHENTICATION_MODE;

  typedef UCHAR NDIS_802_11_RATES[NDIS_802_11_LENGTH_RATES];
  typedef UCHAR NDIS_802_11_RATES_EX[NDIS_802_11_LENGTH_RATES_EX];

  typedef struct _NDIS_802_11_SSID {
    ULONG SsidLength;
    UCHAR Ssid[NDIS_802_11_LENGTH_SSID];
  } NDIS_802_11_SSID,*PNDIS_802_11_SSID;

  typedef struct _NDIS_WLAN_BSSID {
    ULONG Length;
    NDIS_802_11_MAC_ADDRESS MacAddress;
    UCHAR Reserved[2];
    NDIS_802_11_SSID Ssid;
    ULONG Privacy;
    NDIS_802_11_RSSI Rssi;
    NDIS_802_11_NETWORK_TYPE NetworkTypeInUse;
    NDIS_802_11_CONFIGURATION Configuration;
    NDIS_802_11_NETWORK_INFRASTRUCTURE InfrastructureMode;
    NDIS_802_11_RATES SupportedRates;
  } NDIS_WLAN_BSSID,*PNDIS_WLAN_BSSID;

  typedef struct _NDIS_802_11_BSSID_LIST {
    ULONG NumberOfItems;
    NDIS_WLAN_BSSID Bssid[1];
  } NDIS_802_11_BSSID_LIST,*PNDIS_802_11_BSSID_LIST;

  typedef struct _NDIS_WLAN_BSSID_EX {
    ULONG Length;
    NDIS_802_11_MAC_ADDRESS MacAddress;
    UCHAR Reserved[2];
    NDIS_802_11_SSID Ssid;
    ULONG Privacy;
    NDIS_802_11_RSSI Rssi;
    NDIS_802_11_NETWORK_TYPE NetworkTypeInUse;
    NDIS_802_11_CONFIGURATION Configuration;
    NDIS_802_11_NETWORK_INFRASTRUCTURE InfrastructureMode;
    NDIS_802_11_RATES_EX SupportedRates;
    ULONG IELength;
    UCHAR IEs[1];
  } NDIS_WLAN_BSSID_EX,*PNDIS_WLAN_BSSID_EX;

  typedef struct _NDIS_802_11_BSSID_LIST_EX {
    ULONG NumberOfItems;
    NDIS_WLAN_BSSID_EX Bssid[1];
  } NDIS_802_11_BSSID_LIST_EX,*PNDIS_802_11_BSSID_LIST_EX;

  typedef struct _NDIS_802_11_FIXED_IEs {
    UCHAR Timestamp[8];
    USHORT BeaconInterval;
    USHORT Capabilities;
  } NDIS_802_11_FIXED_IEs,*PNDIS_802_11_FIXED_IEs;

  typedef struct _NDIS_802_11_VARIABLE_IEs {
    UCHAR ElementID;
    UCHAR Length;
    UCHAR data[1];
  } NDIS_802_11_VARIABLE_IEs,*PNDIS_802_11_VARIABLE_IEs;

  typedef ULONG NDIS_802_11_FRAGMENTATION_THRESHOLD;
  typedef ULONG NDIS_802_11_RTS_THRESHOLD;
  typedef ULONG NDIS_802_11_ANTENNA;

  typedef enum _NDIS_802_11_PRIVACY_FILTER {
    Ndis802_11PrivFilterAcceptAll,Ndis802_11PrivFilter8021xWEP
  } NDIS_802_11_PRIVACY_FILTER,*PNDIS_802_11_PRIVACY_FILTER;

  typedef enum _NDIS_802_11_WEP_STATUS {
    Ndis802_11WEPEnabled,Ndis802_11Encryption1Enabled = Ndis802_11WEPEnabled,Ndis802_11WEPDisabled,Ndis802_11EncryptionDisabled = Ndis802_11WEPDisabled,
    Ndis802_11WEPKeyAbsent,Ndis802_11Encryption1KeyAbsent = Ndis802_11WEPKeyAbsent,Ndis802_11WEPNotSupported,
    Ndis802_11EncryptionNotSupported = Ndis802_11WEPNotSupported,Ndis802_11Encryption2Enabled,Ndis802_11Encryption2KeyAbsent,
    Ndis802_11Encryption3Enabled,Ndis802_11Encryption3KeyAbsent
  } NDIS_802_11_WEP_STATUS,*PNDIS_802_11_WEP_STATUS,NDIS_802_11_ENCRYPTION_STATUS,*PNDIS_802_11_ENCRYPTION_STATUS;

  typedef enum _NDIS_802_11_RELOAD_DEFAULTS {
    Ndis802_11ReloadWEPKeys
  } NDIS_802_11_RELOAD_DEFAULTS,*PNDIS_802_11_RELOAD_DEFAULTS;

#define NDIS_802_11_AI_REQFI_CAPABILITIES 1
#define NDIS_802_11_AI_REQFI_LISTENINTERVAL 2
#define NDIS_802_11_AI_REQFI_CURRENTAPADDRESS 4

#define NDIS_802_11_AI_RESFI_CAPABILITIES 1
#define NDIS_802_11_AI_RESFI_STATUSCODE 2
#define NDIS_802_11_AI_RESFI_ASSOCIATIONID 4

  typedef struct _NDIS_802_11_AI_REQFI {
    USHORT Capabilities;
    USHORT ListenInterval;
    NDIS_802_11_MAC_ADDRESS CurrentAPAddress;
  } NDIS_802_11_AI_REQFI,*PNDIS_802_11_AI_REQFI;

  typedef struct _NDIS_802_11_AI_RESFI {
    USHORT Capabilities;
    USHORT StatusCode;
    USHORT AssociationId;
  } NDIS_802_11_AI_RESFI,*PNDIS_802_11_AI_RESFI;

  typedef struct _NDIS_802_11_ASSOCIATION_INFORMATION {
    ULONG Length;
    USHORT AvailableRequestFixedIEs;
    NDIS_802_11_AI_REQFI RequestFixedIEs;
    ULONG RequestIELength;
    ULONG OffsetRequestIEs;
    USHORT AvailableResponseFixedIEs;
    NDIS_802_11_AI_RESFI ResponseFixedIEs;
    ULONG ResponseIELength;
    ULONG OffsetResponseIEs;
  } NDIS_802_11_ASSOCIATION_INFORMATION,*PNDIS_802_11_ASSOCIATION_INFORMATION;

  typedef struct _NDIS_802_11_AUTHENTICATION_EVENT {
    NDIS_802_11_STATUS_INDICATION Status;
    NDIS_802_11_AUTHENTICATION_REQUEST Request[1];
  } NDIS_802_11_AUTHENTICATION_EVENT,*PNDIS_802_11_AUTHENTICATION_EVENT;

  typedef struct _NDIS_802_11_TEST {
    ULONG Length;
    ULONG Type;
    __MINGW_EXTENSION union {
      NDIS_802_11_AUTHENTICATION_EVENT AuthenticationEvent;
      NDIS_802_11_RSSI RssiTrigger;
    };
  } NDIS_802_11_TEST,*PNDIS_802_11_TEST;

  typedef enum _NDIS_802_11_MEDIA_STREAM_MODE {
    Ndis802_11MediaStreamOff,Ndis802_11MediaStreamOn
  } NDIS_802_11_MEDIA_STREAM_MODE,*PNDIS_802_11_MEDIA_STREAM_MODE;

#define OID_IRDA_RECEIVING 0x0A010100
#define OID_IRDA_TURNAROUND_TIME 0x0A010101
#define OID_IRDA_SUPPORTED_SPEEDS 0x0A010102
#define OID_IRDA_LINK_SPEED 0x0A010103
#define OID_IRDA_MEDIA_BUSY 0x0A010104

#define OID_IRDA_EXTRA_RCV_BOFS 0x0A010200
#define OID_IRDA_RATE_SNIFF 0x0A010201
#define OID_IRDA_UNICAST_LIST 0x0A010202
#define OID_IRDA_MAX_UNICAST_LIST_SIZE 0x0A010203
#define OID_IRDA_MAX_RECEIVE_WINDOW_SIZE 0x0A010204
#define OID_IRDA_MAX_SEND_WINDOW_SIZE 0x0A010205
#define OID_IRDA_RESERVED1 0x0A01020A
#define OID_IRDA_RESERVED2 0x0A01020F

#define OID_BPC_ADAPTER_CAPS 0x0B010100
#define OID_BPC_DEVICES 0x0B010101
#define OID_BPC_DEVICE_CAPS 0x0B010102
#define OID_BPC_DEVICE_SETTINGS 0x0B010103
#define OID_BPC_CONNECTION_STATUS 0x0B010104
#define OID_BPC_ADDRESS_COMPARE 0x0B010105
#define OID_BPC_PROGRAM_GUIDE 0x0B010106
#define OID_BPC_LAST_ERROR 0x0B020107
#define OID_BPC_POOL 0x0B010108

#define OID_BPC_PROVIDER_SPECIFIC 0x0B020109
#define OID_BPC_ADAPTER_SPECIFIC 0x0B02010A

#define OID_BPC_CONNECT 0x0B01010B
#define OID_BPC_COMMIT 0x0B01010C
#define OID_BPC_DISCONNECT 0x0B01010D
#define OID_BPC_CONNECTION_ENABLE 0x0B01010E
#define OID_BPC_POOL_RESERVE 0x0B01010F
#define OID_BPC_POOL_RETURN 0x0B010110
#define OID_BPC_FORCE_RECEIVE 0x0B010111

#define OID_BPC_LAST 0x0B020112

#define OID_1394_LOCAL_NODE_INFO 0x0C010101
#define OID_1394_VC_INFO 0x0C010102

#define OID_CO_ADD_PVC 0xFE000001
#define OID_CO_DELETE_PVC 0xFE000002
#define OID_CO_GET_CALL_INFORMATION 0xFE000003
#define OID_CO_ADD_ADDRESS 0xFE000004
#define OID_CO_DELETE_ADDRESS 0xFE000005
#define OID_CO_GET_ADDRESSES 0xFE000006
#define OID_CO_ADDRESS_CHANGE 0xFE000007
#define OID_CO_SIGNALING_ENABLED 0xFE000008
#define OID_CO_SIGNALING_DISABLED 0xFE000009
#define OID_CO_AF_CLOSE 0xFE00000A

#define OID_CO_TAPI_CM_CAPS 0xFE001001
#define OID_CO_TAPI_LINE_CAPS 0xFE001002
#define OID_CO_TAPI_ADDRESS_CAPS 0xFE001003
#define OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS 0xFE001004
#define OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS 0xFE001005
#define OID_CO_TAPI_TRANSLATE_TAPI_SAP 0xFE001006
#define OID_CO_TAPI_GET_CALL_DIAGNOSTICS 0xFE001007
#define OID_CO_TAPI_REPORT_DIGITS 0xFE001008
#define OID_CO_TAPI_DONT_REPORT_DIGITS 0xFE001009

#define OID_PNP_CAPABILITIES 0xFD010100
#define OID_PNP_SET_POWER 0xFD010101
#define OID_PNP_QUERY_POWER 0xFD010102
#define OID_PNP_ADD_WAKE_UP_PATTERN 0xFD010103
#define OID_PNP_REMOVE_WAKE_UP_PATTERN 0xFD010104
#define OID_PNP_WAKE_UP_PATTERN_LIST 0xFD010105
#define OID_PNP_ENABLE_WAKE_UP 0xFD010106

#define OID_PNP_WAKE_UP_OK 0xFD020200
#define OID_PNP_WAKE_UP_ERROR 0xFD020201

#define NDIS_PNP_WAKE_UP_MAGIC_PACKET 0x00000001
#define NDIS_PNP_WAKE_UP_PATTERN_MATCH 0x00000002
#define NDIS_PNP_WAKE_UP_LINK_CHANGE 0x00000004

#define OID_TCP_TASK_OFFLOAD 0xFC010201
#define OID_TCP_TASK_IPSEC_ADD_SA 0xFC010202
#define OID_TCP_TASK_IPSEC_DELETE_SA 0xFC010203
#define OID_TCP_SAN_SUPPORT 0xFC010204
#define OID_TCP_TASK_IPSEC_ADD_UDPESP_SA 0xFC010205
#define OID_TCP_TASK_IPSEC_DELETE_UDPESP_SA 0xFC010206

#define OID_FFP_SUPPORT 0xFC010210
#define OID_FFP_FLUSH 0xFC010211
#define OID_FFP_CONTROL 0xFC010212
#define OID_FFP_PARAMS 0xFC010213
#define OID_FFP_DATA 0xFC010214

#define OID_FFP_DRIVER_STATS 0xFC020210
#define OID_FFP_ADAPTER_STATS 0xFC020211

#define OID_QOS_TC_SUPPORTED 0xFB010100
#define OID_QOS_REMAINING_BANDWIDTH 0xFB010101
#define OID_QOS_ISSLOW_FLOW 0xFB010102
#define OID_QOS_BESTEFFORT_BANDWIDTH 0xFB010103
#define OID_QOS_LATENCY 0xFB010104
#define OID_QOS_FLOW_IP_CONFORMING 0xFB010105
#define OID_QOS_FLOW_COUNT 0xFB010106
#define OID_QOS_NON_BESTEFFORT_LIMIT 0xFB010107
#define OID_QOS_SCHEDULING_PROFILES_SUPPORTED 0xFB010108
#define OID_QOS_CURRENT_SCHEDULING_PROFILE 0xFB010109
#define OID_QOS_TIMER_RESOLUTION 0xFB01010A
#define OID_QOS_STATISTICS_BUFFER 0xFB01010B
#define OID_QOS_HIERARCHY_CLASS 0xFB01010C
#define OID_QOS_FLOW_MODE 0xFB01010D
#define OID_QOS_ISSLOW_FRAGMENT_SIZE 0xFB01010E
#define OID_QOS_FLOW_IP_NONCONFORMING 0xFB01010F
#define OID_QOS_FLOW_8021P_CONFORMING 0xFB010110
#define OID_QOS_FLOW_8021P_NONCONFORMING 0xFB010111
#define OID_QOS_ENABLE_AVG_STATS 0xFB010112
#define OID_QOS_ENABLE_WINDOW_ADJUSTMENT 0xFB010113

  typedef struct NDIS_CO_DEVICE_PROFILE {
    NDIS_VAR_DATA_DESC DeviceDescription;
    NDIS_VAR_DATA_DESC DevSpecificInfo;
    ULONG ulTAPISupplementaryPassThru;
    ULONG ulAddressModes;
    ULONG ulNumAddresses;
    ULONG ulBearerModes;
    ULONG ulMaxTxRate;
    ULONG ulMinTxRate;
    ULONG ulMaxRxRate;
    ULONG ulMinRxRate;
    ULONG ulMediaModes;
    ULONG ulGenerateToneModes;
    ULONG ulGenerateToneMaxNumFreq;
    ULONG ulGenerateDigitModes;
    ULONG ulMonitorToneMaxNumFreq;
    ULONG ulMonitorToneMaxNumEntries;
    ULONG ulMonitorDigitModes;
    ULONG ulGatherDigitsMinTimeout;
    ULONG ulGatherDigitsMaxTimeout;
    ULONG ulDevCapFlags;
    ULONG ulMaxNumActiveCalls;
    ULONG ulAnswerMode;
    ULONG ulUUIAcceptSize;
    ULONG ulUUIAnswerSize;
    ULONG ulUUIMakeCallSize;
    ULONG ulUUIDropSize;
    ULONG ulUUISendUserUserInfoSize;
    ULONG ulUUICallInfoSize;
  } NDIS_CO_DEVICE_PROFILE,*PNDIS_CO_DEVICE_PROFILE;

  typedef ULONG IPAddr,IPMask;
  typedef ULONG SPI_TYPE;

  typedef enum _OFFLOAD_OPERATION_E {
    AUTHENTICATE = 1,ENCRYPT
  } OFFLOAD_OPERATION_E;

  typedef struct _OFFLOAD_ALGO_INFO {
    ULONG algoIdentifier;
    ULONG algoKeylen;
    ULONG algoRounds;
  } OFFLOAD_ALGO_INFO,*POFFLOAD_ALGO_INFO;

  typedef enum _OFFLOAD_CONF_ALGO {
    OFFLOAD_IPSEC_CONF_NONE,OFFLOAD_IPSEC_CONF_DES,OFFLOAD_IPSEC_CONF_RESERVED,OFFLOAD_IPSEC_CONF_3_DES,OFFLOAD_IPSEC_CONF_MAX
  } OFFLOAD_CONF_ALGO;

  typedef enum _OFFLOAD_INTEGRITY_ALGO {
    OFFLOAD_IPSEC_INTEGRITY_NONE,OFFLOAD_IPSEC_INTEGRITY_MD5,OFFLOAD_IPSEC_INTEGRITY_SHA,OFFLOAD_IPSEC_INTEGRITY_MAX
  } OFFLOAD_INTEGRITY_ALGO;

  typedef struct _OFFLOAD_SECURITY_ASSOCIATION {
    OFFLOAD_OPERATION_E Operation;
    SPI_TYPE SPI;
    OFFLOAD_ALGO_INFO IntegrityAlgo;
    OFFLOAD_ALGO_INFO ConfAlgo;
    OFFLOAD_ALGO_INFO Reserved;
  } OFFLOAD_SECURITY_ASSOCIATION,*POFFLOAD_SECURITY_ASSOCIATION;

#define OFFLOAD_MAX_SAS 3

#define OFFLOAD_INBOUND_SA 0x0001
#define OFFLOAD_OUTBOUND_SA 0x0002

  typedef struct _OFFLOAD_IPSEC_ADD_SA {
    IPAddr SrcAddr;
    IPMask SrcMask;
    IPAddr DestAddr;
    IPMask DestMask;
    ULONG Protocol;
    USHORT SrcPort;
    USHORT DestPort;
    IPAddr SrcTunnelAddr;
    IPAddr DestTunnelAddr;
    USHORT Flags;
    SHORT NumSAs;
    OFFLOAD_SECURITY_ASSOCIATION SecAssoc[OFFLOAD_MAX_SAS];
    HANDLE OffloadHandle;
    ULONG KeyLen;
    UCHAR KeyMat[1];
  } OFFLOAD_IPSEC_ADD_SA,*POFFLOAD_IPSEC_ADD_SA;

  typedef struct _OFFLOAD_IPSEC_DELETE_SA {
    HANDLE OffloadHandle;
  } OFFLOAD_IPSEC_DELETE_SA,*POFFLOAD_IPSEC_DELETE_SA;

  typedef enum _UDP_ENCAP_TYPE {
    OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_IKE,OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_OTHER
  } UDP_ENCAP_TYPE,*PUDP_ENCAP_TYPE;

  typedef struct _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY {
    UDP_ENCAP_TYPE UdpEncapType;
    USHORT DstEncapPort;
  } OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY,*POFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY;

  typedef struct _OFFLOAD_IPSEC_ADD_UDPESP_SA {
    IPAddr SrcAddr;
    IPMask SrcMask;
    IPAddr DstAddr;
    IPMask DstMask;
    ULONG Protocol;
    USHORT SrcPort;
    USHORT DstPort;
    IPAddr SrcTunnelAddr;
    IPAddr DstTunnelAddr;
    USHORT Flags;
    SHORT NumSAs;
    OFFLOAD_SECURITY_ASSOCIATION SecAssoc[OFFLOAD_MAX_SAS];
    HANDLE OffloadHandle;
    OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY EncapTypeEntry;
    HANDLE EncapTypeEntryOffldHandle;
    ULONG KeyLen;
    UCHAR KeyMat[1];
  } OFFLOAD_IPSEC_ADD_UDPESP_SA,*POFFLOAD_IPSEC_ADD_UDPESP_SA;

  typedef struct _OFFLOAD_IPSEC_DELETE_UDPESP_SA {
    HANDLE OffloadHandle;
    HANDLE EncapTypeEntryOffldHandle;
  } OFFLOAD_IPSEC_DELETE_UDPESP_SA,*POFFLOAD_IPSEC_DELETE_UDPESP_SA;

  typedef ULONG NDIS_VLAN_ID;

  typedef enum _NDIS_MEDIUM {
    NdisMedium802_3,NdisMedium802_5,NdisMediumFddi,NdisMediumWan,NdisMediumLocalTalk,NdisMediumDix,NdisMediumArcnetRaw,NdisMediumArcnet878_2,
    NdisMediumAtm,NdisMediumWirelessWan,NdisMediumIrda,NdisMediumBpc,NdisMediumCoWan,NdisMedium1394,NdisMediumInfiniBand,NdisMediumMax
  } NDIS_MEDIUM,*PNDIS_MEDIUM;

  typedef enum _NDIS_PHYSICAL_MEDIUM {
    NdisPhysicalMediumUnspecified,NdisPhysicalMediumWirelessLan,NdisPhysicalMediumCableModem,NdisPhysicalMediumPhoneLine,
    NdisPhysicalMediumPowerLine,NdisPhysicalMediumDSL,NdisPhysicalMediumFibreChannel,NdisPhysicalMedium1394,NdisPhysicalMediumWirelessWan,
    NdisPhysicalMediumNative802_11,NdisPhysicalMediumBluetooth,NdisPhysicalMediumInfiniband,NdisPhysicalMediumWiMax,NdisPhysicalMediumUWB,
    NdisPhysicalMedium802_3,NdisPhysicalMedium802_5,NdisPhysicalMediumIrda,NdisPhysicalMediumWiredWAN,NdisPhysicalMediumWiredCoWan,
    NdisPhysicalMediumOther,NdisPhysicalMediumMax
  } NDIS_PHYSICAL_MEDIUM,*PNDIS_PHYSICAL_MEDIUM;

#define NDIS_PROTOCOL_ID_DEFAULT 0x00
#define NDIS_PROTOCOL_ID_TCP_IP 0x02
#define NDIS_PROTOCOL_ID_IPX 0x06
#define NDIS_PROTOCOL_ID_NBF 0x07
#define NDIS_PROTOCOL_ID_MAX 0x0F
#define NDIS_PROTOCOL_ID_MASK 0x0F

  typedef struct _TRANSPORT_HEADER_OFFSET {
    USHORT ProtocolType;
    USHORT HeaderOffset;
  } TRANSPORT_HEADER_OFFSET,*PTRANSPORT_HEADER_OFFSET;

  typedef struct _NETWORK_ADDRESS {
    USHORT AddressLength;
    USHORT AddressType;
    UCHAR Address[1];
  } NETWORK_ADDRESS,*PNETWORK_ADDRESS;

  typedef struct _NETWORK_ADDRESS_LIST {
    LONG AddressCount;
    USHORT AddressType;
    NETWORK_ADDRESS Address[1];
  } NETWORK_ADDRESS_LIST,*PNETWORK_ADDRESS_LIST;

  typedef struct _NETWORK_ADDRESS_IP {
    USHORT sin_port;
    ULONG in_addr;
    UCHAR sin_zero[8];
  } NETWORK_ADDRESS_IP,*PNETWORK_ADDRESS_IP;

#define NETWORK_ADDRESS_LENGTH_IP sizeof (NETWORK_ADDRESS_IP)

  typedef struct _NETWORK_ADDRESS_IPX {
    ULONG NetworkAddress;
    UCHAR NodeAddress[6];
    USHORT Socket;
  } NETWORK_ADDRESS_IPX,*PNETWORK_ADDRESS_IPX;

#define NETWORK_ADDRESS_LENGTH_IPX sizeof (NETWORK_ADDRESS_IPX)

  typedef enum _NDIS_HARDWARE_STATUS {
    NdisHardwareStatusReady,NdisHardwareStatusInitializing,NdisHardwareStatusReset,NdisHardwareStatusClosing,NdisHardwareStatusNotReady
  } NDIS_HARDWARE_STATUS,*PNDIS_HARDWARE_STATUS;

  typedef struct _GEN_GET_TIME_CAPS {
    ULONG Flags;
    ULONG ClockPrecision;
  } GEN_GET_TIME_CAPS,*PGEN_GET_TIME_CAPS;

#define READABLE_LOCAL_CLOCK 0x00000001
#define CLOCK_NETWORK_DERIVED 0x00000002
#define CLOCK_PRECISION 0x00000004
#define RECEIVE_TIME_INDICATION_CAPABLE 0x00000008
#define TIMED_SEND_CAPABLE 0x00000010
#define TIME_STAMP_CAPABLE 0x00000020

  typedef struct _GEN_GET_NETCARD_TIME {
    ULONGLONG ReadTime;
  } GEN_GET_NETCARD_TIME,*PGEN_GET_NETCARD_TIME;

  typedef struct _NDIS_PM_PACKET_PATTERN {
    ULONG Priority;
    ULONG Reserved;
    ULONG MaskSize;
    ULONG PatternOffset;
    ULONG PatternSize;
    ULONG PatternFlags;
  } NDIS_PM_PACKET_PATTERN,*PNDIS_PM_PACKET_PATTERN;

  typedef enum _NDIS_DEVICE_POWER_STATE {
    NdisDeviceStateUnspecified = 0,NdisDeviceStateD0,NdisDeviceStateD1,NdisDeviceStateD2,NdisDeviceStateD3,NdisDeviceStateMaximum
  } NDIS_DEVICE_POWER_STATE,*PNDIS_DEVICE_POWER_STATE;

  typedef struct _NDIS_PM_WAKE_UP_CAPABILITIES {
    NDIS_DEVICE_POWER_STATE MinMagicPacketWakeUp;
    NDIS_DEVICE_POWER_STATE MinPatternWakeUp;
    NDIS_DEVICE_POWER_STATE MinLinkChangeWakeUp;
  } NDIS_PM_WAKE_UP_CAPABILITIES,*PNDIS_PM_WAKE_UP_CAPABILITIES;

#define NDIS_DEVICE_WAKE_UP_ENABLE 0x00000001
#define NDIS_DEVICE_WAKE_ON_PATTERN_MATCH_ENABLE 0x00000002
#define NDIS_DEVICE_WAKE_ON_MAGIC_PACKET_ENABLE 0x00000004

  typedef struct _NDIS_PNP_CAPABILITIES {
    ULONG Flags;
    NDIS_PM_WAKE_UP_CAPABILITIES WakeUpCapabilities;
  } NDIS_PNP_CAPABILITIES,*PNDIS_PNP_CAPABILITIES;

  typedef enum _NDIS_FDDI_ATTACHMENT_TYPE {
    NdisFddiTypeIsolated = 1,NdisFddiTypeLocalA,NdisFddiTypeLocalB,NdisFddiTypeLocalAB,NdisFddiTypeLocalS,NdisFddiTypeWrapA,
    NdisFddiTypeWrapB,NdisFddiTypeWrapAB,NdisFddiTypeWrapS,NdisFddiTypeCWrapA,NdisFddiTypeCWrapB,NdisFddiTypeCWrapS,NdisFddiTypeThrough
  } NDIS_FDDI_ATTACHMENT_TYPE,*PNDIS_FDDI_ATTACHMENT_TYPE;

  typedef enum _NDIS_FDDI_RING_MGT_STATE {
    NdisFddiRingIsolated = 1,NdisFddiRingNonOperational,NdisFddiRingOperational,NdisFddiRingDetect,NdisFddiRingNonOperationalDup,
    NdisFddiRingOperationalDup,NdisFddiRingDirected,NdisFddiRingTrace
  } NDIS_FDDI_RING_MGT_STATE,*PNDIS_FDDI_RING_MGT_STATE;

  typedef enum _NDIS_FDDI_LCONNECTION_STATE {
    NdisFddiStateOff = 1,NdisFddiStateBreak,NdisFddiStateTrace,NdisFddiStateConnect,NdisFddiStateNext,NdisFddiStateSignal,
    NdisFddiStateJoin,NdisFddiStateVerify,NdisFddiStateActive,NdisFddiStateMaintenance
  } NDIS_FDDI_LCONNECTION_STATE,*PNDIS_FDDI_LCONNECTION_STATE;

  typedef enum _NDIS_WAN_MEDIUM_SUBTYPE {
    NdisWanMediumHub,NdisWanMediumX_25,NdisWanMediumIsdn,NdisWanMediumSerial,NdisWanMediumFrameRelay,NdisWanMediumAtm,
    NdisWanMediumSonet,NdisWanMediumSW56K,NdisWanMediumPPTP,NdisWanMediumL2TP,NdisWanMediumIrda,NdisWanMediumParallel,NdisWanMediumPppoe
  } NDIS_WAN_MEDIUM_SUBTYPE,*PNDIS_WAN_MEDIUM_SUBTYPE;

  typedef enum _NDIS_WAN_HEADER_FORMAT {
    NdisWanHeaderNative,NdisWanHeaderEthernet
  } NDIS_WAN_HEADER_FORMAT,*PNDIS_WAN_HEADER_FORMAT;

  typedef enum _NDIS_WAN_QUALITY {
    NdisWanRaw,NdisWanErrorControl,NdisWanReliable
  } NDIS_WAN_QUALITY,*PNDIS_WAN_QUALITY;

  typedef struct _NDIS_WAN_PROTOCOL_CAPS {
    ULONG Flags;
    ULONG Reserved;
  } NDIS_WAN_PROTOCOL_CAPS,*PNDIS_WAN_PROTOCOL_CAPS;

#define WAN_PROTOCOL_KEEPS_STATS 0x00000001

  typedef enum _NDIS_802_5_RING_STATE {
    NdisRingStateOpened = 1,NdisRingStateClosed,NdisRingStateOpening,NdisRingStateClosing,NdisRingStateOpenFailure,NdisRingStateRingFailure
  } NDIS_802_5_RING_STATE,*PNDIS_802_5_RING_STATE;

  typedef enum _NDIS_MEDIA_STATE {
    NdisMediaStateConnected,NdisMediaStateDisconnected
  } NDIS_MEDIA_STATE,*PNDIS_MEDIA_STATE;

  typedef ULONG Priority_802_3;

  typedef struct _NDIS_CO_LINK_SPEED {
    ULONG Outbound;
    ULONG Inbound;
  } NDIS_CO_LINK_SPEED,*PNDIS_CO_LINK_SPEED;

#ifndef _NDIS_
  typedef int NDIS_STATUS,*PNDIS_STATUS;
#endif

  typedef struct _NDIS_GUID {
    GUID Guid;
    __MINGW_EXTENSION union {
      NDIS_OID Oid;
      NDIS_STATUS Status;
    };
    ULONG Size;
    ULONG Flags;
  } NDIS_GUID,*PNDIS_GUID;

#define fNDIS_GUID_TO_OID 0x00000001
#define fNDIS_GUID_TO_STATUS 0x00000002
#define fNDIS_GUID_ANSI_STRING 0x00000004
#define fNDIS_GUID_UNICODE_STRING 0x00000008
#define fNDIS_GUID_ARRAY 0x00000010
#define fNDIS_GUID_ALLOW_READ 0x00000020
#define fNDIS_GUID_ALLOW_WRITE 0x00000040

#define NDIS_PACKET_TYPE_DIRECTED 0x00000001
#define NDIS_PACKET_TYPE_MULTICAST 0x00000002
#define NDIS_PACKET_TYPE_ALL_MULTICAST 0x00000004
#define NDIS_PACKET_TYPE_BROADCAST 0x00000008
#define NDIS_PACKET_TYPE_SOURCE_ROUTING 0x00000010
#define NDIS_PACKET_TYPE_PROMISCUOUS 0x00000020
#define NDIS_PACKET_TYPE_SMT 0x00000040
#define NDIS_PACKET_TYPE_ALL_LOCAL 0x00000080
#define NDIS_PACKET_TYPE_GROUP 0x00001000
#define NDIS_PACKET_TYPE_ALL_FUNCTIONAL 0x00002000
#define NDIS_PACKET_TYPE_FUNCTIONAL 0x00004000
#define NDIS_PACKET_TYPE_MAC_FRAME 0x00008000

#define NDIS_RING_SIGNAL_LOSS 0x00008000
#define NDIS_RING_HARD_ERROR 0x00004000
#define NDIS_RING_SOFT_ERROR 0x00002000
#define NDIS_RING_TRANSMIT_BEACON 0x00001000
#define NDIS_RING_LOBE_WIRE_FAULT 0x00000800
#define NDIS_RING_AUTO_REMOVAL_ERROR 0x00000400
#define NDIS_RING_REMOVE_RECEIVED 0x00000200
#define NDIS_RING_COUNTER_OVERFLOW 0x00000100
#define NDIS_RING_SINGLE_STATION 0x00000080
#define NDIS_RING_RING_RECOVERY 0x00000040

#define NDIS_PROT_OPTION_ESTIMATED_LENGTH 0x00000001
#define NDIS_PROT_OPTION_NO_LOOPBACK 0x00000002
#define NDIS_PROT_OPTION_NO_RSVD_ON_RCVPKT 0x00000004
#define NDIS_PROT_OPTION_SEND_RESTRICTED 0x00000008

#define NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA 0x00000001
#define NDIS_MAC_OPTION_RECEIVE_SERIALIZED 0x00000002
#define NDIS_MAC_OPTION_TRANSFERS_NOT_PEND 0x00000004
#define NDIS_MAC_OPTION_NO_LOOPBACK 0x00000008
#define NDIS_MAC_OPTION_FULL_DUPLEX 0x00000010
#define NDIS_MAC_OPTION_EOTX_INDICATION 0x00000020
#define NDIS_MAC_OPTION_8021P_PRIORITY 0x00000040
#define NDIS_MAC_OPTION_SUPPORTS_MAC_ADDRESS_OVERWRITE 0x00000080
#define NDIS_MAC_OPTION_RECEIVE_AT_DPC 0x00000100
#define NDIS_MAC_OPTION_8021Q_VLAN 0x00000200
#define NDIS_MAC_OPTION_RESERVED 0x80000000

#define NDIS_MEDIA_CAP_TRANSMIT 0x00000001
#define NDIS_MEDIA_CAP_RECEIVE 0x00000002

#define NDIS_CO_MAC_OPTION_DYNAMIC_LINK_SPEED 0x00000001

  typedef struct _NDIS_IRDA_PACKET_INFO {
    ULONG ExtraBOFs;
    ULONG MinTurnAroundTime;
  } NDIS_IRDA_PACKET_INFO,*PNDIS_IRDA_PACKET_INFO;

#ifdef WIRELESS_WAN

  typedef enum _NDIS_WW_NETWORK_TYPE {
    NdisWWGeneric,NdisWWMobitex,NdisWWPinpoint,NdisWWCDPD,NdisWWArdis,NdisWWDataTAC,NdisWWMetricom,NdisWWGSM,NdisWWCDMA,NdisWWTDMA,
    NdisWWAMPS,NdisWWInmarsat,NdisWWpACT,NdisWWFlex,NdisWWIDEN
  } NDIS_WW_NETWORK_TYPE;

  typedef enum _NDIS_WW_HEADER_FORMAT {
    NdisWWDIXEthernetFrames,NdisWWMPAKFrames,NdisWWRDLAPFrames,NdisWWMDC4800Frames,NdisWWNCLFrames
  } NDIS_WW_HEADER_FORMAT;

  typedef enum _NDIS_WW_ENCRYPTION_TYPE {
    NdisWWUnknownEncryption = -1,NdisWWNoEncryption,NdisWWDefaultEncryption,NdisWWDESEncryption,NdisWWRC2Encryption,NdisWWRC4Encryption,NdisWWRC5Encryption
  } NDIS_WW_ENCRYPTION_TYPE,*PNDIS_WW_ENCRYPTION_TYPE;

  typedef enum _WW_ADDRESS_FORMAT {
    WW_IEEE_ADDRESS = 0,WW_MOBITEX_MAN_ADDRESS,WW_DATATAC_RDLAP_ADDRESS,WW_DATATAC_MDC4800_ADDRESS,WW_DATATAC_RESERVED,WW_IPv4_ADDRESS,
    WW_IPv6_ADDRESS,WW_PROPRIETARY_ADDRESS
  } WW_ADDRESS_FORMAT;

  typedef enum _WW_GEN_SUM_EXCEPTION {
    SIM_STATUS_OK = 0,SIM_STATUS_ERROR,SIM_STATUS_MISSING,SIM_STATUS_NO_RESPONSE,SIM_STATUS_REMOVED,SIM_STATUS_CRYPT_ERROR,
    SIM_STATUS_AUTH_ERROR,SIM_STATUS_NEED_PIN,SIM_STATUS_NEED_PUK,SIM_STATUS_WRONG
  } WW_GEN_SIM_EXCEPTION;

  typedef struct _NDIS_WW_INDICATION_REQUEST {
    NDIS_OID Oid;
    ULONG uIndicationFlag;
    ULONG uApplicationToken;
    HANDLE hIndicationHandle;
    INT iPollingInterval;
    NDIS_VAR_DATA_DESC InitialValue;
    NDIS_VAR_DATA_DESC OIDIndicationValue;
    NDIS_VAR_DATA_DESC TriggerValue;
  } NDIS_WW_INDICATION_REQUEST,*PNDIS_WW_INDICATION_REQUEST;

#define OID_INDICATION_REQUEST_ENABLE 0x0000
#define OID_INDICATION_REQUEST_CANCEL 0x0001

  typedef struct _WW_DEVICE_INFO {
    NDIS_VAR_DATA_DESC Manufacturer;
    NDIS_VAR_DATA_DESC ModelNum;
    NDIS_VAR_DATA_DESC SWVersionNum;
    NDIS_VAR_DATA_DESC SerialNum;
  } WW_DEVICE_INFO,*PWW_DEVICE_INFO;

  typedef INT WW_OPERATION_MODE;
  typedef INT WW_LOCK_STATUS;
  typedef INT WW_DISABLE_TRANSMITTER;
  typedef NDIS_VAR_DATA_DESC WW_NETWORK_ID;
  typedef NDIS_VAR_DATA_DESC WW_PERMANENT_ADDRESS;

  typedef struct _WW_CURRENT_ADDRESS {
    NDIS_WW_HEADER_FORMAT Format;
    NDIS_VAR_DATA_DESC Address;
  } WW_CURRENT_ADDRESS,*PWW_CURRENT_ADDRESS;

  typedef BOOLEAN WW_SUSPEND_DRIVER;
  typedef NDIS_VAR_DATA_DESC WW_BASESTATION_ID;
  typedef NDIS_VAR_DATA_DESC WW_CHANNEL_ID;
  typedef BOOLEAN WW_ENCRYPTION_STATE;
  typedef INT WW_CHANNEL_QUALITY;
  typedef INT WW_REGISTRATION_STATUS;
  typedef ULONG WW_RADIO_LINK_SPEED;
  typedef ULONG WW_LATENCY;
  typedef INT WW_BATTERY_LEVEL;
  typedef INT WW_EXTERNAL_POWER;

  typedef struct _WW_PING_ADDRESS {
    WW_ADDRESS_FORMAT Format;
    NDIS_VAR_DATA_DESC TargetAddress;
    UINT uTime;
  } WW_PING_ADDRESS;

  typedef struct _WW_RECEIVE_SIGNAL_STRENGTH_INDICATOR {
    INT iDecibels;
    INT iFactor;
  } WW_RECEIVE_SIGNAL_STRENGTH_INDICATOR;

  typedef struct _WW_SIM_STATUS {
    BOOLEAN bHasSIM;
    BOOLEAN bBlocked;
    BOOLEAN bLocked;
    BOOLEAN bInitialized;
    UINT uCountdown;
  } WW_SIM_STATUS;

  typedef struct _WW_ENABLE_SIM_PIN {
    BOOLEAN bEnabled;
    NDIS_VAR_DATA_DESC CurrentPIN;
  } WW_ENABLE_SIM_PIN;

  typedef struct _WW_CHANGE_SIM_PIN {
    NDIS_VAR_DATA_DESC OldPIN;
    NDIS_VAR_DATA_DESC NewPIN;
  } WW_CHANGE_SIM_PIN;

  typedef NDIS_VAR_DATA_DESC WW_ENABLE_SIM_PUK;
  typedef NDIS_VAR_DATA_DESC WW_MET_FUNCTION;
  typedef BOOLEAN WW_TAC_COMPRESSION;

  typedef struct _WW_TAC_SETCONFIG {
    NDIS_VAR_DATA_DESC RCV_MODE;
    NDIS_VAR_DATA_DESC TX_CONTROL;
    NDIS_VAR_DATA_DESC RX_CONTROL;
    NDIS_VAR_DATA_DESC FLOW_CONTROL;
    NDIS_VAR_DATA_DESC RESET_CNF;
    NDIS_VAR_DATA_DESC READ_CNF;
  } WW_TAC_SETCONFIG,*PWW_TAC_SETCONFIG;

  typedef struct _WW_TAC_GETSTATUS {
    BOOLEAN Action;
    NDIS_VAR_DATA_DESC Command;
    NDIS_VAR_DATA_DESC Option;
    NDIS_VAR_DATA_DESC Response;
  } WW_TAC_GETSTATUS,*PWW_TAC_GETSTATUS;

  typedef NDIS_VAR_DATA_DESC WW_TAC_USERHEADER;

  typedef struct _WW_TAC_GET_RESPONSE {
    UINT SDUTag;
    NDIS_VAR_DATA_DESC Response;
  } WW_TAC_GET_RESPONSE;

  typedef INT WW_TAC_DISABLE_RECEIVER;
  typedef INT WW_TAC_ANTENNA_MODE;
  typedef INT WW_TAC_FLUSH_DATA;
  typedef INT WW_TAC_SHUTDOWN_DEVICE;
  typedef BOOLEAN WW_TAC_TRANSMITTER_KEYED;

  typedef struct _WW_TAC_SYSTEM_TABLE {
    UINT SystemCount;
    UCHAR ContryTable[32];
    UCHAR PrefixTable[32];
    UCHAR IDTable[32];
  } WW_TAC_SYSTEM_TABLE;

  typedef struct _WW_TAC_CHANNEL_TABLE {
    UINT ChannelCount;
    UCHAR ChannelTable[64];
    UCHAR AttrTable[64];
  } WW_TAC_CHANNEL_TABLE;

  typedef NDIS_VAR_DATA_DESC WW_TAC_STATISTICS;

  typedef struct _WW_ARD_SNDCP {
    NDIS_VAR_DATA_DESC Version;
    INT BlockSize;
    INT Window;
  } WW_ARD_SNDCP,*PWW_ARD_SNDCP;

  typedef BOOLEAN WW_ARD_CHANNEL_STATUS;

  typedef struct _WW_ARD_DATAGRAM {
    BOOLEAN LoadLevel;
    INT SessionTime;
    NDIS_VAR_DATA_DESC HostAddr;
    NDIS_VAR_DATA_DESC THostAddr;
  } WW_ARD_DATAGRAM,*PWW_ARD_DATAGRAM;

  typedef struct _WW_CDPD_SPNI {
    ULONG SPNI[10];
    INT OperatingMode;
  } WW_CDPD_SPNI,*PWW_CDPD_SPNI;

  typedef struct _WW_CDPD_WIDE_AREA_SERVICE_ID {
    ULONG WASI[10];
    INT OperatingMode;
  } WW_CDPD_WIDE_AREA_SERVICE_ID,*PWW_CDPD_WIDE_AREA_SERVICE_ID;

  typedef INT WW_CDPD_AREA_COLOR;
  typedef ULONG WW_CDPD_TX_POWER_LEVEL;
  typedef NDIS_VAR_DATA_DESC WW_CDPD_EID;
  typedef INT WW_CDPD_HEADER_COMPRESSION;
  typedef INT WW_CDPD_DATA_COMPRESSION;

  typedef struct _WW_CDPD_CHANNEL_SELECT {
    ULONG ChannelID;
    ULONG fixedDuration;
  } WW_CDPD_CHANNEL_SELECT,*PWW_CDPD_CHANNEL_SELECT;

  typedef enum _WW_CDPD_CHANNEL_STATE {
    CDPDChannelNotAvail,CDPDChannelScanning,CDPDChannelInitAcquired,CDPDChannelAcquired,CDPDChannelSleeping,CDPDChannelWaking,
    CDPDChannelCSDialing,CDPDChannelCSRedial,CDPDChannelCSAnswering,CDPDChannelCSConnected,CDPDChannelCSSuspended
  } WW_CDPD_CHANNEL_STATE,*PWW_CDPD_CHANNEL_STATE;

  typedef enum _WW_CDPD_NEI_FORMAT {
    CDPDNeiIPv4,CDPDNeiCLNP,CDPDNeiIPv6
  } WW_CDPD_NEI_FORMAT,*PWW_CDPD_NEI_FORMAT;

  typedef enum _WW_CDPD_NEI_TYPE {
    CDPDNeiIndividual,CDPDNeiMulticast,CDPDNeiBroadcast
  } WW_CDPD_NEI_TYPE;

  typedef struct _WW_CDPD_NEI {
    ULONG uNeiIndex;
    WW_CDPD_NEI_FORMAT NeiFormat;
    WW_CDPD_NEI_TYPE NeiType;
    WORD NeiGmid;
    NDIS_VAR_DATA_DESC NeiAddress;
  } WW_CDPD_NEI;

  typedef enum _WW_CDPD_NEI_STATE {
    CDPDUnknown,CDPDRegistered,CDPDDeregistered
  } WW_CDPD_NEI_STATE,*PWW_CDPD_NEI_STATE;

  typedef enum _WW_CDPD_NEI_SUB_STATE {
    CDPDPending,CDPDNoReason,CDPDMDISNotCapable,CDPDNEINotAuthorized,CDPDInsufficientAuth,CDPDUnsupportedAuth,CDPDUsageExceeded,
    CDPDDeniedThisNetwork
  } WW_CDPD_NEI_SUB_STATE;

  typedef struct _WW_CDPD_NEI_REG_STATE {
    ULONG uNeiIndex;
    WW_CDPD_NEI_STATE NeiState;
    WW_CDPD_NEI_SUB_STATE NeiSubState;
  } WW_CDPD_NEI_REG_STATE,*PWW_CDPD_NEI_REG_STATE;

  typedef struct _WW_CDPD_SERVICE_PROVIDER_ID {
    ULONG SPI[10];
    INT OperatingMode;
  } WW_CDPD_SERVICE_PROVIDER_ID,*PWW_CDPD_SERVICE_PROVIDER_ID;

  typedef INT WW_CDPD_SLEEP_MODE;
  typedef ULONG WW_CDPD_TEI;

  typedef struct _WW_CDPD_CIRCUIT_SWITCHED {
    INT service_preference;
    INT service_status;
    INT connect_rate;
    NDIS_VAR_DATA_DESC dial_code[20];
    ULONG sid;
    INT a_b_side_selection;
    INT AMPS_channel;
    ULONG action;
    NDIS_VAR_DATA_DESC default_dial[20];
    NDIS_VAR_DATA_DESC call_back[20];
    ULONG sid_list[10];
    ULONG inactivity_timer;
    ULONG receive_timer;
    ULONG conn_resp_timer;
    ULONG reconn_resp_timer;
    ULONG disconn_timer;
    ULONG NEI_reg_timer;
    ULONG reconn_retry_timer;
    ULONG link_reset_timer;
    ULONG link_reset_ack_timer;
    ULONG n401_retry_limit;
    ULONG n402_retry_limit;
    ULONG n404_retry_limit;
    ULONG n405_retry_limit;
  } WW_CDPD_CIRCUIT_SWITCHED,*WW_PCDPD_CIRCUIT_SWITCHED;

  typedef ULONG WW_CDPD_RSSI;
  typedef INT WW_CDPD_CS_SERVICE_PREFERENCE;
  typedef INT WW_CDPD_CS_SERVICE_STATUS;

  typedef struct _WW_CDPD_CS_INFO {
    INT ConnectRage;
    NDIS_VAR_DATA_DESC DialCode;
    UINT SID;
    INT ABSideSelection;
    INT AMPSChannel;
  } WW_CDPD_CS_INFO;

  typedef UINT WW_CDPD_CS_SUSPEND;
  typedef NDIS_VAR_DATA_DESC WW_CDPD_DEFAULT_DIAL_CODE;

  typedef struct _WW_CDPD_CS_CALLBACK {
    UINT Enabled;
    NDIS_VAR_DATA_DESC Number;
  } WW_CDPD_CS_CALLBACK;

  typedef struct _WW_CDPD_CS_SID_LIST {
    UINT AMPSystemId[10];
  } WW_CDPD_CS_SID_LIST;

  typedef struct _WW_CDPD_CS_CONFIGURATION {
    UINT InactivityTimer;
    UINT ReceiveTimer;
    UINT ConnResTimer;
    UINT ReconnRespTimer;
    UINT DisconnTimer;
    UINT NEIRegTimer;
    UINT ReconnRetryTimer;
    UINT LinkResetTimer;
    UINT LinkResetAckTimer;
    UINT n401RetryLimit;
    UINT n402RetryLimit;
    UINT n404RetryLimit;
    UINT n405RetryLimit;
  } WW_CDPD_CS_CONFIGURATION;

  typedef INT WW_PIN_AUTHORIZED;

  typedef struct _WW_PIN_LOCATION {
    INT Latitude;
    INT Longitude;
    INT Altitude;
    INT FixTime;
    INT NetTime;
    INT LocQuality;
    INT LatReg;
    INT LongReg;
    INT GMTOffset;
  } WW_PIN_LOCATION,*PWW_PIN_LOCATION;

  typedef ULONG WW_MBX_MAILBOX_FLAG;

  typedef struct _WW_MBX_PMAN {
    BOOLEAN ACTION;
    ULONG MAN;
    UCHAR PASSWORD[8];
  } WW_MBX_PMAN,*PWW_MBX_PMAN;

  typedef struct _WW_MBX_FLEXLIST {
    INT count;
    ULONG MAN[7];
  } WW_MBX_FLEXLIST;

  typedef struct _WW_MBX_GROUPLIST {
    INT count;
    ULONG MAN[15];
  } WW_MBX_GROUPLIST;

  typedef enum _WW_MBX_TRAFFIC_AREA {
    unknown_traffic_area,in_traffic_area,in_auth_traffic_area,unauth_traffic_area
  } WW_MBX_TRAFFIC_AREA;

  typedef INT WW_MBX_LIVE_DIE;

  typedef struct _WW_MBX_CHANNEL_PAIR {
    ULONG Mobile_Tx;
    ULONG Mobile_Rx;
  } WW_MBX_CHANNEL_PAIR,*PWW_MBX_CHANNEL_PAIR;

  typedef struct _WW_MBX_TEMPDEFAULTLIST {
    ULONG Length;
    WW_MBX_CHANNEL_PAIR ChannelPair[1];
  } WW_MBX_TEMPDEFAULTLIST,*WW_PMBX_TEMPDEFAULTLIST;
#endif /* WIRELESS_WAN */

  typedef struct _BPC_FILETIME {
    ULONG dwLowDateTime;
    ULONG dwHighDateTime;
  } BPC_FILETIME,*PBPC_FILETIME;

  typedef PVOID BPC_HANDLE;

#define BPC_MIN_DIMENSION 1
#define BPC_MAX_BUFFER_SIZE 64
#define BPC_MIN_BUFFER_SIZE 4
#define BPC_DEVICE_ANY ((BPC_HANDLE) 0xFFFFFFFF)

  typedef enum _NDIS_BPC_INDICATE_REASON {
    bpcBufferFull = 0,bpcBufferForced,bpcBufferTimeOut,bpcBufferDiscontinuity,bpcBufferOverflow,bpcBufferStatusEvent
  } NDIS_BPC_INDICATE_REASON,*PNDIS_BPC_INDICATE_REASON;

#define BPC_STREAM_TYPE_GENERIC_MIN 0x01000000
#define BPC_STREAM_TYPE_RAW 0x01000000
#define BPC_STREAM_TYPE_MPT_128 0x01000001
#define BPC_STREAM_TYPE_MPT_128_CRC 0x01000002
#define BPC_STREAM_TYPE_IP 0x01000003
#define BPC_STREAM_TYPE_PROVIDER_MIN 0x02000000
#define BPC_STREAM_TYPE_PROVIDER_MAX 0x02ffffff
#define BPC_STREAM_TYPE_ADAPTER_MIN 0x03000000
#define BPC_STREAM_TYPE_ADAPTER_MAX 0x03ffffff

  typedef struct _NDIS_BPC_ADAPTER_CAPS {
    ULONG ulBPCMajorRev;
    ULONG ulBPCMinorRev;
    ULONG ulcHSDataDevices;
    ULONG ulbpsHSDeviceMax;
    ULONG ulcLSDataDevices;
    ULONG ulbpsLSDeviceMax;
    ULONG ulcTuningDevices;
    ULONG ulcbLargestStatus;
    ULONG ulVendorId;
    ULONG ulAdapterId;
    GUID guidProvider;
  } NDIS_BPC_ADAPTER_CAPS,*PNDIS_BPC_ADAPTER_CAPS;

  typedef struct _NDIS_BPC_DEVICES {
    ULONG ulcDevices;
    BPC_HANDLE rgnhDevices[BPC_MIN_DIMENSION];
  } NDIS_BPC_DEVICES,*PNDIS_BPC_DEVICES;

#define CbDevices(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICES,rgnhDevices) + (cnt) *sizeof(BPC_HANDLE))

  typedef struct NDIS_BPC_DEVICE_CAPS {
    BPC_HANDLE nhDevice;
    ULONG ulBPCCaps;
    ULONG ulbpsMax;
    ULONG ulcStreamTypes;
    ULONG rgulStreamTypes[BPC_MIN_DIMENSION];
  } NDIS_BPC_DEVICE_CAPS,*PNDIS_BPC_DEVICE_CAPS;

#define CbDeviceCaps(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICE_CAPS,rgulStreamTypes) + (cnt)*sizeof(ULONG))

#define BPCCapBusMasteredData 0x01
#define BPCCapIndependentTuner 0x02
#define BPCCapExternalDataBus 0x04
#define BPCCapLowSpeedData 0x10
#define BPCCapHighSpeedData 0x20

  typedef struct NDIS_BPC_DEVICE_SETTINGS {
    BPC_HANDLE nhDevice;
    ULONG ulBPCCaps;
    ULONG ulcConnections;
    BOOLEAN fEnabled;
    ULONG ulStreamType;
    ULONG ulcbAddressConnection;
    ULONG rgulAddressConnection[BPC_MIN_DIMENSION];
  } NDIS_BPC_DEVICE_SETTINGS,*PNDIS_BPC_DEVICE_SETTINGS;

#define CbDeviceSettings(cnt) (FIELD_OFFSET(NDIS_BPC_DEVICE_SETTINGS,rgulAddressConnection) + (cnt)*sizeof(ULONG))

#define BPC_CONNECT_STATE_UNCOMMITTED 0
#define BPC_CONNECT_STATE_QUEUED 1
#define BPC_CONNECT_STATE_ACTIVE 2
#define BPC_CONNECT_STATE_DISCONNECTING 3

  typedef struct NDIS_BPC_CONNECTION_STATUS {
    BPC_HANDLE nhConnection;
    BPC_HANDLE nhDevice;
    ULONG ulConnectPriority;
    ULONG ulDisconnectPriority;
    ULONG ulbpsAverage;
    ULONG ulbpsBurst;
    ULONG ulState;
    BOOLEAN fEnabled;
  } NDIS_BPC_CONNECTION_STATUS,*PNDIS_BPC_CONNECTION_STATUS;

  typedef struct NDIS_BPC_ADDRESS_COMPARE {
    BOOLEAN fEqual;
    ULONG ulcbFirstOffset;
    ULONG ulcbFirstLength;
    ULONG ulcbSecondOffset;
    ULONG ulcbSecondLength;
  } NDIS_BPC_ADDRESS_COMPARE,*PNDIS_BPC_ADDRESS_COMPARE;

#define BPC_GUIDE_GENERIC_MIN 0x01000000
#define BPC_GUIDE_GENERIC_MAX 0x01ffffff
#define BPC_GUIDE_PROVIDER_MIN 0x02000000
#define BPC_GUIDE_PROVIDER_MAX 0x02ffffff
#define BPC_GUIDE_ADAPTER_MIN 0x03000000
#define BPC_GUIDE_ADAPTER_MAX 0x03ffffff

  typedef struct NDIS_BPC_PROGRAM_GUIDE {
    ULONG ulGuideType;
    BPC_FILETIME ftLastUpdate;
    ULONG ulChangeNumber;
    ULONG ulcbGuideSize;
    ULONG rgulGuideData[BPC_MIN_DIMENSION];
  } NDIS_BPC_PROGRAM_GUIDE,*PNDIS_BPC_PROGRAM_GUIDE;

  typedef enum _NDIS_BPC_ERROR {
    bpcErrorUnknownFailure = 0xc0ff0000,bpcErrorHardwareFailure,bpcErrorProviderFailure,bpcErrorNoDataDevice,bpcErrorNoTuningDevice,
    bpcErrorDeviceNotCapable,bpcErrorConflictingDevice,bpcErrorConflictingCapability,bpcErrorNoBufferMemory,bpcErrorNoResources,
    bpcErrorAdapterClosing,bpcErrorConnectionClosing,bpcErrorTooComplex,bpcErrorProviderNotSupported,
    bpcErrorUnknownProviderStructure,bpcErrorAddressNotSupported,bpcErrorInvalidAddress,bpcErrorUnknownAdapterStructure
  } NDIS_BPC_ERROR,*PNDIS_BPC_ERROR;

  typedef struct NDIS_BPC_LAST_ERROR {
    ULONG ulErrorContext;
    ULONG ulBPCError;
    ULONG ulAdapterError;
    ULONG ulAdapterContext;
  } NDIS_BPC_LAST_ERROR,*PNDIS_BPC_LAST_ERROR;

  typedef struct NDIS_BPC_POOL {
    BPC_HANDLE nhConnection;
    ULONG ulcbPoolSize;
    ULONG ulcbMaxBufferSize;
    ULONG ulcbBufferReserved;
  } NDIS_BPC_POOL,*PNDIS_BPC_POOL;

  typedef struct NDIS_BPC_CONNECT {
    BPC_HANDLE nhConnection;
    BPC_HANDLE nhDevice;
    ULONG ulConnectPriority;
    ULONG ulDisconnectPriority;
    BOOLEAN fImmediate;
    ULONG ulcbAddress;
    GUID guidProvider;
    ULONG rgulAddress[BPC_MIN_DIMENSION];
  } NDIS_BPC_CONNECT,*PNDIS_BPC_CONNECT;

#define CbConnect(cnt) (FIELD_OFFSET(NDIS_BPC_CONNECT,rgulAddress) + (cnt)*sizeof(ULONG))

  typedef struct NDIS_BPC_COMMIT {
    ULONG ulcConnections;
    BPC_HANDLE rgnhConnections[BPC_MIN_DIMENSION];
  } NDIS_BPC_COMMIT,*PNDIS_BPC_COMMIT;

  typedef struct NDIS_BPC_DISCONNECT {
    BPC_HANDLE nhConnection;
  } NDIS_BPC_DISCONNECT,*PNDIS_BPC_DISCONNECT;

  typedef struct NDIS_BPC_CONNECTION_ENABLE {
    BPC_HANDLE nhConnection;
    BOOLEAN fEnabled;
  } NDIS_BPC_CONNECTION_ENABLE,*PNDIS_BPC_CONNECTION_ENABLE;

  typedef struct NDIS_BPC_POOL_RETURN {
    BPC_HANDLE nhConnection;
  } NDIS_BPC_POOL_RETURN,*PNDIS_BPC_POOL_RETURN;

  typedef struct NDIS_BPC_FORCE_RECEIVE {
    BPC_HANDLE nhConnection;
    ULONG ulReasonCode;
  } NDIS_BPC_FORCE_RECEIVE,*PNDIS_BPC_FORCE_RECEIVE;

  typedef struct NDIS_BPC_MEDIA_SPECIFIC_INFORMATION {
    BPC_HANDLE nhConnection;
    ULONG ulBPCStreamType;
    ULONG ulReasonCode;
    PVOID pvMiniportReserved1;
    ULONG ulMiniportReserved2;
  } NDIS_BPC_MEDIA_SPECIFIC_INFORMATION,*PNDIS_BPC_MEDIA_SPECIFIC_INFORMATION;

#define BPC_CATEGORY_BPC 0x01000000
#define BPC_CATEGORY_PROVIDER 0x02000000
#define BPC_CATEGORY_ADAPTER 0x03000000

#define BPC_STATUS_CONNECTED 0x00000001
#define BPC_STATUS_QUEUED 0x00000002
#define BPC_STATUS_ACTIVE 0x00000003
#define BPC_STATUS_DISCONNECTED 0x00000004
#define BPC_STATUS_OVERFLOW 0x00000005
#define BPC_STATUS_DATA_STOP 0x00000006
#define BPC_STATUS_DATA_START 0x00000007
#define BPC_STATUS_DATA_ERROR 0x00000008

  typedef struct NDIS_BPC_STATUS {
    ULONG ulStatusCategory;
    ULONG ulStatusType;
    ULONG ulcbStatus;
    ULONG rgulStatus;
  } NDIS_BPC_STATUS,*PNDIS_BPC_STATUS;

  typedef struct NDIS_BPC_STATUS_CONNECTION {
    BPC_HANDLE nhConnection;
    BPC_HANDLE nhDevice;
  } NDIS_BPC_STATUS_CONNECTED,*PNDIS_BPC_STATUS_CONNECTED;

#ifdef __cplusplus
}
#endif

#define NDIS_MINIPORT_BUS_MASTER 0x00000001
#define NDIS_MINIPORT_WDM_DRIVER 0x00000002
#define NDIS_MINIPORT_SG_LIST 0x00000004
#define NDIS_MINIPORT_SUPPORTS_MEDIA_QUERY 0x00000008
#define NDIS_MINIPORT_INDICATES_PACKETS 0x00000010
#define NDIS_MINIPORT_IGNORE_PACKET_QUEUE 0x00000020
#define NDIS_MINIPORT_IGNORE_REQUEST_QUEUE 0x00000040
#define NDIS_MINIPORT_IGNORE_TOKEN_RING_ERRORS 0x00000080
#define NDIS_MINIPORT_INTERMEDIATE_DRIVER 0x00000100
#define NDIS_MINIPORT_IS_NDIS_5 0x00000200
#define NDIS_MINIPORT_IS_CO 0x00000400
#define NDIS_MINIPORT_DESERIALIZE 0x00000800
#define NDIS_MINIPORT_REQUIRES_MEDIA_POLLING 0x00001000
#define NDIS_MINIPORT_SUPPORTS_MEDIA_SENSE 0x00002000
#define NDIS_MINIPORT_NETBOOT_CARD 0x00004000
#define NDIS_MINIPORT_PM_SUPPORTED 0x00008000
#define NDIS_MINIPORT_SUPPORTS_MAC_ADDRESS_OVERWRITE 0x00010000
#define NDIS_MINIPORT_USES_SAFE_BUFFER_APIS 0x00020000
#define NDIS_MINIPORT_HIDDEN 0x00040000
#define NDIS_MINIPORT_SWENUM 0x00080000
#define NDIS_MINIPORT_SURPRISE_REMOVE_OK 0x00100000
#define NDIS_MINIPORT_NO_HALT_ON_SUSPEND 0x00200000
#define NDIS_MINIPORT_HARDWARE_DEVICE 0x00400000
#define NDIS_MINIPORT_SUPPORTS_CANCEL_SEND_PACKETS 0x00800000
#define NDIS_MINIPORT_64BITS_DMA 0x01000000
#define NDIS_MINIPORT_USE_NEW_BITS 0x02000000
#define NDIS_MINIPORT_EXCLUSIVE_INTERRUPT 0x04000000
#define NDIS_MINIPORT_SENDS_PACKET_ARRAY 0x08000000
#define NDIS_MINIPORT_FILTER_IM 0x10000000
#define NDIS_MINIPORT_SHORT_PACKETS_ARE_PADDED 0x20000000

#endif /* _NTDDNDIS_ */

