/*
 * Code for class I18N_UNIX_C_FUNCTIONS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i1105.h"
#include <eif_langinfo.h>
#include <iconv.h>
#include <locale.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F128_1799
static EIF_INTEGER_32 inline_F128_1799 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F128_1799
#endif
#ifndef INLINE_F128_1798
static EIF_POINTER inline_F128_1798 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F128_1798
#endif
#ifndef INLINE_F128_1793
static EIF_POINTER inline_F128_1793 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F128_1793
#endif
#ifndef INLINE_F128_1795
static EIF_POINTER inline_F128_1795 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F128_1795
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_UNIX_C_FUNCTIONS}.unix_set_locale */
void F128_1791 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTEAA("unix_set_locale", 127, Current, 3, 1, 1960);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(1025, 0x01).id, 1025, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1026_8962(RTCW(loc1), arg1);
	RTHOOK(2);
	ti4_1 = inline_F128_1799();
	tp1 = F1026_8984(RTCW(loc1));
	loc2 = inline_F128_1798(ti4_1, tp1);
	RTHOOK(3);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(4);
		loc1 = RTLNS(eif_new_type(1025, 0x01).id, 1025, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F1026_8966(RTCW(loc1), loc2);
		RTHOOK(5);
		tr1 = RTOSCF(1797,F128_1797, (Current));
		tr2 = F1026_8976(RTCW(loc1));
		F202_2998(RTCW(tr1), tr2);
	} else {
		RTHOOK(6);
		tr1 = RTOSCF(1797,F128_1797, (Current));
		tr2 = RTMS_EX_H("POSIX",5,1331472728);
		F202_2998(RTCW(tr1), tr2);
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info_managed */
EIF_REFERENCE F128_1792 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Result);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("unix_get_locale_info_managed", 127, Current, 0, 1, 1961);
	RTGC;
	RTHOOK(1);
	Result = RTLNS(eif_new_type(438, 0x01).id, 438, _OBJSIZ_0_1_0_1_0_1_1_0_);
	tp1 = inline_F128_1793(arg1);
	F439_6060(RTCW(Result), tp1, ((EIF_INTEGER_32) 0L));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info */
EIF_POINTER F128_1793 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_get_locale_info", 127, Current, 0, 1, 1962);
	Result = inline_F128_1793 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_is_available */
EIF_BOOLEAN F128_1794 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTEAA("unix_is_available", 127, Current, 2, 1, 1963);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(1025, 0x01).id, 1025, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1026_8962(RTCW(loc1), arg1);
	RTHOOK(2);
	ti4_1 = inline_F128_1799();
	tp1 = F1026_8984(RTCW(loc1));
	tp1 = inline_F128_1798(ti4_1, tp1);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tp1 != loc2);
	RTHOOK(3);
	tr1 = F128_1796(Current);
	F128_1791(Current, tr1);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_current_codeset */
EIF_POINTER F128_1795 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_current_codeset", 127, Current, 0, 0, 1964);
	Result = inline_F128_1795 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name */
EIF_REFERENCE F128_1796 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTEAA("unix_locale_name", 127, Current, 0, 0, 1965);
	RTGC;
	RTHOOK(1);
	Result = *(EIF_REFERENCE *)(RTCV(RTOSCF(1797,F128_1797, (Current))));
	RTHOOK(3);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name_cell */
static EIF_REFERENCE F128_1797_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	

	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTEAA("unix_locale_name_cell", 127, Current, 0, 0, 1966);
	RTGC;
	RTOSP (1797);
#define Result RTOSR(1797)
	RTOC_NEW(Result);
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {0xFF01,201,0xFF01,1120,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 201, _OBJSIZ_1_0_0_0_0_0_0_0_);
	}
	tr2 = RTMS_EX_H("POSIX",5,1331472728);
	F202_2998(RTCW(tr1), tr2);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (1797);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F128_1797 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(1797,F128_1797_body,(Current));
}

/* {I18N_UNIX_C_FUNCTIONS}.c_setlocale */
EIF_POINTER F128_1798 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_setlocale", 127, Current, 0, 2, 1958);
	Result = inline_F128_1798 ((EIF_INTEGER_32) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_lc_all */
EIF_INTEGER_32 F128_1799 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_lc_all", 127, Current, 0, 0, 1959);
	Result = inline_F128_1799 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit105 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
