/*
 * Code for class KL_EXECUTION_ENVIRONMENT
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "kl303.h"
#include <eif_system.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F958_6629
static EIF_INTEGER_32 inline_F958_6629 (EIF_POINTER arg1, EIF_INTEGER_32 arg2)
{
	#ifdef EIF_WINDOWS
	char *exePath;
	if (_get_pgmptr(&exePath) != 0)
		exePath = "";
#elif EIF_OS == EIF_OS_DARWIN
		/* MacOS X < 10.4 */
	char exePath[PATH_MAX];
	uint32_t len = sizeof(exePath);
	if (_NSGetExecutablePath(exePath, &len) != 0) {
		exePath[0] = '\0'; // buffer too small (!)
	} else {
		// resolve symlinks, ., .. if possible
		char *canonicalPath = realpath(exePath, NULL);
		if (canonicalPath != NULL) {
			strncpy(exePath,canonicalPath,len);
			free(canonicalPath);
		}
	}
#elif EIF_OS == EIF_OS_FREEBSD
	char exePath[2048];
	int mib[4];  mib[0] = CTL_KERN;  mib[1] = KERN_PROC;  mib[2] = KERN_PROC_PATHNAME;  mib[3] = -1;
	size_t len = sizeof(exePath);
	if (sysctl(mib, 4, exePath, &len, NULL, 0) != 0)
		exePath[0] = '\0';
#elif defined(EIF_SOLARIS)
	char exePath[PATH_MAX];
	if (realpath(getexecname(), exePath) == NULL)
		exePath[0] = '\0';
#else
		/* Linux */
	char exePath[PATH_MAX];
	size_t len = readlink("/proc/self/exe", exePath, sizeof(exePath));
	if (len == -1 || len == sizeof(exePath))
		len = 0;
	exePath[len] = '\0';
#endif
EIF_INTEGER l_result = strlen(exePath) + 1;
if (l_result <= arg2)
	strcpy(arg1, exePath);
return l_result;
	;
}
#define INLINE_F958_6629
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {KL_EXECUTION_ENVIRONMENT}.variable_value */
EIF_REFERENCE F958_6623 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(7);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLR(5,loc2);
	RTLR(6,Result);
	RTLIU(7);
	
	RTGC;
	tr1 = RTOSCF(6628,F958_6628, (Current));
	tr2 = RTOSCF(6064,F919_6064, (Current));
	tr2 = F778_4070(RTCW(tr2), arg1);
	tr1 = F247_2404(RTCW(tr1), tr2);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		loc2 = loc1;
		loc2 = RTRV(eif_new_type(898, 0x01),loc2);
		if (EIF_TEST(loc2)) {
			RTLE;
			return (EIF_REFERENCE) loc2;
		} else {
			tb1 = F894_5585(loc1);
			if (tb1) {
				tr1 = F891_5476(loc1);
				RTLE;
				return (EIF_REFERENCE) tr1;
			} else {
				tr1 = RTLNS(eif_new_type(911, 0x01).id, 911, _OBJSIZ_0_0_0_0_0_0_0_0_);
				Result = F912_5988(RTCW(tr1), loc1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {KL_EXECUTION_ENVIRONMENT}.current_executable_pathname */
static EIF_REFERENCE F958_6625_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(2);
	RTLR(0,loc3);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEV;
	RTGC;
	RTOSP (6625);
#define Result RTOSR(6625)
	RTOC_NEW(Result);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 250L);
	loc3 = RTLNS(eif_new_type(212, 0x01).id, 212, _OBJSIZ_0_1_0_1_0_1_1_0_);
	F213_2008(RTCW(loc3), loc1);
	tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
	loc2 = inline_F958_6629(tp1, loc1);
	if ((EIF_BOOLEAN) (loc2 > loc1)) {
		loc1 = (EIF_INTEGER_32) loc2;
		F213_2098(RTCW(loc3), loc1);
		tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
		loc2 = inline_F958_6629(tp1, loc1);
	}
	if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN) (loc2 <= loc1))) {
		tr1 = RTLNS(eif_new_type(898, 0x01).id, 898, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = *(EIF_POINTER *)(RTCW(loc3)+ _PTROFF_0_1_0_1_0_0_);
		F897_5723(RTCW(tr1), tp1);
		Result = (EIF_REFERENCE) tr1;
	} else {
		Result = RTMS_EX_H("",0,0);
	}
	RTOSE (6625);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F958_6625 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(6625,F958_6625_body,(Current));
}

/* {KL_EXECUTION_ENVIRONMENT}.set_variable_value */
void F958_6626 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(6);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,arg2);
	RTLR(4,tr3);
	RTLR(5,arg1);
	RTLIU(6);
	
	RTGC;
	tr1 = RTOSCF(6628,F958_6628, (Current));
	tr2 = RTOSCF(6064,F919_6064, (Current));
	tr2 = F778_4071(RTCW(tr2), arg2);
	tr3 = RTOSCF(6064,F919_6064, (Current));
	tr3 = F778_4071(RTCW(tr3), arg1);
	F247_2417(RTCW(tr1), tr2, tr3);
	RTLE;
}

/* {KL_EXECUTION_ENVIRONMENT}.environment_impl */
static EIF_REFERENCE F958_6628_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (6628);
#define Result RTOSR(6628)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(246, 0x01).id, 246, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (6628);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F958_6628 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(6628,F958_6628_body,(Current));
}

/* {KL_EXECUTION_ENVIRONMENT}.eif_current_executable_pathname_ptr */
EIF_INTEGER_32 F958_6629 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F958_6629 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2);
	return Result;
}

void EIF_Minit303 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
