/*
 * Code for class PROCESS_UNIX_PROCESS_MANAGER
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr650.h"
#include <unistd.h>
#include <string.h>
#include "eif_built_in.h"
#include "eif_except.h"
#include "eif_main.h"
#include "eif_process.h"
#include <sys/types.h>
#include "eif_memory.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F307_5011
static void inline_F307_5011 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F307_5011
#endif
#ifndef INLINE_F1237_11602
static int inline_F1237_11602 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFEXITED(arg1))
	;
}
#define INLINE_F1237_11602
#endif
#ifndef INLINE_F1237_11603
static int inline_F1237_11603 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFSIGNALED(arg1))
	;
}
#define INLINE_F1237_11603
#endif
#ifndef INLINE_F321_5082
static int inline_F321_5082 (void)
{
	#ifdef WORKBENCH
	return EIF_TEST(is_debug_mode());
#else
	return EIF_FALSE;
#endif
	;
}
#define INLINE_F321_5082
#endif
#ifndef INLINE_F321_5081
static void inline_F321_5081 (EIF_BOOLEAN arg1)
{
	#ifdef WORKBENCH
	set_debug_mode (arg1 ? 1 : 0);
#endif
	;
}
#define INLINE_F321_5081
#endif
#ifndef INLINE_F307_5001
static void inline_F307_5001 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F307_5001
#endif
#ifndef INLINE_F307_5016
static void inline_F307_5016 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F307_5016
#endif
#ifndef INLINE_F307_4997
static void inline_F307_4997 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F307_4997
#endif
#ifndef INLINE_F307_4998
static void inline_F307_4998 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F307_4998
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_PROCESS_MANAGER}.make */
void F1237_11544 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_REFERENCE arg3)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg3);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLR(4,arg2);
	RTLIU(5);
	
	RTEAA("make", 1236, Current, 3, 3, 15263);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg3 != NULL)) {
		RTHOOK(2);
		tr1 = RTLNSMART(eif_new_type(1408, 0).id);
		F1409_13377(RTCW(tr1), arg3);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(3);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) NULL;
	}
	RTHOOK(4);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_4_) = (EIF_REFERENCE) arg1;
	RTHOOK(5);
	F1237_11556(Current, arg2);
	RTHOOK(6);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	RTHOOK(7);
	tr1 = RTMS_EX_H("",0,0);
	F1237_11558(Current, tr1);
	RTHOOK(8);
	tr1 = RTMS_EX_H("",0,0);
	F1237_11559(Current, tr1);
	RTHOOK(9);
	tr1 = RTMS_EX_H("",0,0);
	F1237_11560(Current, tr1);
	RTHOOK(10);
	F1237_11606(Current, (EIF_BOOLEAN) 0);
	RTHOOK(20);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_arguments */
void F1237_11556 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,Current);
	RTLR(3,loc2);
	RTLR(4,tr1);
	RTLIU(5);
	
	RTEAA("set_arguments", 1236, Current, 2, 1, 15275);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		RTHOOK(2);
		{
			static EIF_TYPE_INDEX typarr0[] = {1165,1522,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
			loc1 = RTLNSMART(typres0.id);
		}
		F1166_10495(RTCW(loc1), ((EIF_INTEGER_32) 0L));
		RTHOOK(3);
		loc2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R8176[Dtype(RTCW(arg1))-687])(arg1);
		for (;;) {
			tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R8545[Dtype(loc2)-1030])(loc2);
			if (tb1) break;
			RTHOOK(4);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R8544[Dtype(loc2)-1030])(loc2);
			tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin__o (tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8354[Dtype(RTCW(loc1))-897])(loc1, tr1);
			RTHOOK(5);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R8546[Dtype(loc2)-1030])(loc2);
		}
	}
	RTHOOK(6);
	RTAR(Current, loc1);
	*(EIF_REFERENCE *)(Current + _REFACS_5_) = (EIF_REFERENCE) loc1;
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_close_nonstandard_files */
void F1237_11557 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("set_close_nonstandard_files", 1236, Current, 0, 1, 15276);
	RTHOOK(1);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_) = (EIF_BOOLEAN) arg1;
	RTHOOK(3);
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_input_file_name */
void F1237_11558 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("set_input_file_name", 1236, Current, 0, 1, 15277);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_6_) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_output_file_name */
void F1237_11559 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("set_output_file_name", 1236, Current, 0, 1, 15278);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_7_) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_file_name */
void F1237_11560 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("set_error_file_name", 1236, Current, 0, 1, 15279);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTHOOK(3);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	RTHOOK(5);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_same_as_output */
void F1237_11561 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_error_same_as_output", 1236, Current, 0, 0, 15280);
	RTGC;
	RTHOOK(1);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	RTHOOK(3);
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) NULL;
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.wait_for_process */
void F1237_11562 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc2 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc3 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("wait_for_process", 1236, Current, 3, 2, 15281);
	RTGC;
	RTHOOK(1);
	inline_F307_5011(arg1, arg2, (EIF_BOOLEAN *) &(loc2), (EIF_INTEGER_32 *) &(loc1), (EIF_BOOLEAN *) &(loc3));
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_) = (EIF_BOOLEAN) loc3;
	RTHOOK(3);
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) {
		RTHOOK(4);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) loc2;
		RTHOOK(5);
		*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_) = (EIF_INTEGER_32) loc1;
		RTHOOK(6);
		tb1 = '\0';
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_)) {
			tb2 = '\01';
			ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
			if (!EIF_TEST (inline_F1237_11602(ti4_1))) {
				ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
				tb2 = EIF_TEST (inline_F1237_11603(ti4_1));
			}
			tb1 = tb2;
		}
		if (tb1) {
			RTHOOK(7);
			F1237_11606(Current, (EIF_BOOLEAN) 0);
		} else {
			RTHOOK(8);
			F1237_11606(Current, (EIF_BOOLEAN) 1);
		}
	} else {
		RTHOOK(9);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		RTHOOK(10);
		F1237_11606(Current, (EIF_BOOLEAN) 0);
	}
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.close_pipes */
void F1237_11563 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTEAA("close_pipes", 1236, Current, 3, 0, 15282);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		F1232_11087(loc1);
	}
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(4);
		F1232_11086(loc2);
	}
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		RTHOOK(6);
		F1232_11086(loc3);
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.spawn_nowait */
#undef EIF_VOLATILE
#define EIF_VOLATILE volatile
void F1237_11564 (EIF_REFERENCE Current, EIF_BOOLEAN arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3)
{
	GTCX
	RTEX;
	RTED;
	EIF_REFERENCE EIF_VOLATILE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc2 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN EIF_VOLATILE loc3 = (EIF_BOOLEAN) 0;
	EIF_REFERENCE EIF_VOLATILE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE saved_except = (EIF_REFERENCE) 0;
	EIF_POINTER  EIF_VOLATILE tp1;
	EIF_REFERENCE  EIF_VOLATILE tr1 = NULL;
	EIF_INTEGER_32  EIF_VOLATILE ti4_1;
	EIF_BOOLEAN  EIF_VOLATILE tb1;
	RTLD;
	RTXD;
	
	RTLI(8);
	RTLR(0,loc5);
	RTLR(1,Current);
	RTLR(2,loc1);
	RTLR(3,loc4);
	RTLR(4,loc2);
	RTLR(5,tr1);
	RTLR(6,arg2);
	RTLR(7,saved_except);
	RTLIU(8);
	RTXSLS;
	
	RTEAA("spawn_nowait", 1236, Current, 5, 3, 15283);
	RTGC;
	RTE_T
	RTHOOK(1);
	loc5 = F1237_11586(Current);
	RTHOOK(2);
	RTAR(Current, loc5);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) loc5;
	RTHOOK(3);
	F1237_11587(Current);
	RTHOOK(4);
	loc1 = RTLNS(eif_new_type(656, 0x00).id, 656, _OBJSIZ_0_0_0_1_0_0_0_0_);
	RTHOOK(5);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(6);
	if ((EIF_BOOLEAN)(loc4 != NULL)) {
		RTHOOK(7);
		loc2 = F657_9113(RTCW(loc1));
		RTHOOK(8);
		F657_9129(RTCW(loc1), loc4);
	}
	RTHOOK(9);
	loc3 = EIF_TEST (inline_F321_5082());
	RTHOOK(10);
	F321_5080(Current);
	RTHOOK(11);
	ti4_1 = F307_5000(Current);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ti4_1;
	RTHOOK(12);
	switch (*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_)) {
		case -1L:
			RTHOOK(13);
			inline_F321_5081(loc3);
			RTHOOK(14);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				RTHOOK(15);
				F657_9129(RTCW(loc1), loc2);
			}
			break;
		case 0L:
			RTHOOK(16);
			eif_gc_stop();
			RTHOOK(17);
			if (arg3) {
				RTHOOK(18);
				inline_F307_5001();
				RTHOOK(19);
				if (arg1) {
					RTHOOK(20);
					ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_);
					inline_F307_5016(ti4_1);
				}
			}
			RTHOOK(21);
			F1237_11589(Current);
			RTHOOK(22);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
			tb1 = *(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_);
			tp1 = F1237_11597(Current, arg2);
			F307_5002(Current, tr1, loc5, tb1, tp1);
			break;
		default:
			RTHOOK(23);
			inline_F321_5081(loc3);
			RTHOOK(24);
			F1237_11588(Current);
			RTHOOK(25);
			*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
			RTHOOK(26);
			F1237_11606(Current, (EIF_BOOLEAN) 1);
			RTHOOK(27);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				RTHOOK(28);
				F657_9129(RTCW(loc1), loc2);
			}
			break;
	}
	RTE_E
	RTXSC;
	RTHOOK(29);
	if ((EIF_BOOLEAN)(*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(30);
		tr1 = RTLNS(eif_new_type(452, 0x00).id, 452, _OBJSIZ_0_0_0_0_0_0_0_0_);
		esdie(((EIF_INTEGER_32) 1L));
	}
	RTHOOK(31);
	inline_F321_5081(loc3);
	/* NOTREACHED */
	RTE_EE
	RTHOOK(32);
	RTEOK;
	RTLE;
}
#undef EIF_VOLATILE
#define EIF_VOLATILE

/* {PROCESS_UNIX_PROCESS_MANAGER}.read_output_to_special */
void F1237_11567 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("read_output_to_special", 1236, Current, 1, 1, 15286);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		F1232_11113(loc1, arg1);
		RTHOOK(3);
		tb1 = *(EIF_BOOLEAN *)(loc1+ _CHROFF_2_1_);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) !tb1;
	} else {
		RTHOOK(4);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		RTHOOK(5);
		F1284_12461(RTCW(arg1));
		
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.built_argument_list */
EIF_REFERENCE F1237_11586 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTCFDT;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTEAA("built_argument_list", 1236, Current, 3, 0, 15241);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_5_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		{
			static EIF_TYPE_INDEX typarr0[] = {940,1522,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
		ti4_1 = F1166_10516(loc2);
		F941_9791(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
		RTHOOK(3);
		loc3 = F1166_10509(loc2);
		RTHOOK(4);
		loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		for (;;) {
			tb1 = F1096_10216(loc3);
			if (tb1) break;
			RTHOOK(5);
			tr1 = F1096_10207(loc3);
			F941_9815(RTCW(Result), tr1, loc1);
			RTHOOK(6);
			loc1++;
			RTHOOK(7);
			F1096_10222(loc3);
		}
	} else {
		RTHOOK(8);
		{
			static EIF_TYPE_INDEX typarr0[] = {940,1522,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		F941_9791(RTCW(Result), *(EIF_REFERENCE *)(Current + _REFACS_4_), ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 1L));
		RTHOOK(9);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) Result;
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.open_files_and_pipes */
void F1237_11587 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLIU(6);
	
	RTEAA("open_files_and_pipes", 1236, Current, 4, 0, 15242);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(307, 0x00).id, 307, _OBJSIZ_0_0_0_0_0_0_0_0_);
	RTHOOK(2);
	*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) NULL;
	RTHOOK(3);
	*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) NULL;
	RTHOOK(4);
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_)) {
		RTHOOK(5);
		tr1 = F308_5017(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(6);
		loc2 = *(EIF_REFERENCE *)(Current + _REFACS_6_);
		RTHOOK(7);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc2 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R11907[Dtype(RTCW(loc2))-1526])(loc2);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			RTHOOK(8);
			tr1 = RTLNSMART(eif_new_type(1233, 0).id);
			F1233_11162(RTCW(tr1), loc2);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(9);
	*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) NULL;
	RTHOOK(10);
	*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) NULL;
	RTHOOK(11);
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_)) {
		RTHOOK(12);
		tr1 = F308_5017(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(13);
		loc3 = *(EIF_REFERENCE *)(Current + _REFACS_7_);
		RTHOOK(14);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc3 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R11907[Dtype(RTCW(loc3))-1526])(loc3);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			RTHOOK(15);
			tr1 = RTLNSMART(eif_new_type(1233, 0).id);
			F1233_11164(RTCW(tr1), loc3);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(16);
	*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) NULL;
	RTHOOK(17);
	*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) NULL;
	RTHOOK(18);
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		RTHOOK(19);
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_)) {
			RTHOOK(20);
			tr1 = F308_5017(RTCW(loc1));
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(21);
			loc4 = *(EIF_REFERENCE *)(Current + _REFACS_8_);
			RTHOOK(22);
			tb1 = '\0';
			if ((EIF_BOOLEAN)(loc4 != NULL)) {
				tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R11907[Dtype(RTCW(loc4))-1526])(loc4);
				tb1 = (EIF_BOOLEAN) !tb2;
			}
			if (tb1) {
				RTHOOK(23);
				tr1 = RTLNSMART(eif_new_type(1233, 0).id);
				F1233_11164(RTCW(tr1), loc4);
				RTAR(Current, tr1);
				*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTHOOK(24);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_parent_process_files */
void F1237_11588 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTEAA("setup_parent_process_files", 1236, Current, 6, 0, 15243);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		F1232_11086(loc1);
	} else {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			RTHOOK(4);
			F1233_11247(loc2);
		}
	}
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		RTHOOK(6);
		F1232_11087(loc3);
	} else {
		RTHOOK(7);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			RTHOOK(8);
			F1233_11247(loc4);
		}
	}
	RTHOOK(9);
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		RTHOOK(10);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			RTHOOK(11);
			F1232_11087(loc5);
		} else {
			RTHOOK(12);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				RTHOOK(13);
				F1233_11247(loc6);
			}
		}
	}
	RTHOOK(14);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_child_process_files */
void F1237_11589 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTEAA("setup_child_process_files", 1236, Current, 6, 0, 15244);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_2_7_2_1_);
		F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		RTHOOK(3);
		F1232_11087(loc1);
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			RTHOOK(5);
			ti4_1 = F1233_11174(loc2);
			F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		}
	}
	RTHOOK(6);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		RTHOOK(7);
		ti4_1 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_7_2_2_);
		F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		RTHOOK(8);
		F1232_11086(loc3);
	} else {
		RTHOOK(9);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			RTHOOK(10);
			ti4_1 = F1233_11174(loc4);
			F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(11);
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		RTHOOK(12);
		inline_F307_4997(((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 2L));
	} else {
		RTHOOK(13);
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			RTHOOK(14);
			ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_7_2_2_);
			F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			RTHOOK(15);
			F1232_11086(loc5);
		} else {
			RTHOOK(16);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				RTHOOK(17);
				ti4_1 = F1233_11174(loc6);
				F1237_11590(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			}
		}
	}
	RTHOOK(18);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.move_desc */
void F1237_11590 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("move_desc", 1236, Current, 0, 2, 15245);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != arg2)) {
		RTHOOK(2);
		inline_F307_4997(arg1, arg2);
		RTHOOK(3);
		inline_F307_4998(arg1);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.environment_table_as_pointer */
EIF_POINTER F1237_11597 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc10 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(10);
	RTLR(0,arg1);
	RTLR(1,loc7);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,loc8);
	RTLR(5,loc9);
	RTLR(6,loc10);
	RTLR(7,loc6);
	RTLR(8,loc2);
	RTLR(9,Current);
	RTLIU(10);
	
	RTEAA("environment_table_as_pointer", 1236, Current, 10, 1, 15252);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		tb2 = F846_9675(RTCW(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		RTHOOK(2);
		loc7 = F1155_10379(RTCW(arg1));
		for (;;) {
			tb1 = F1085_10192(loc7);
			if (tb1) break;
			RTHOOK(3);
			tb2 = '\0';
			tr1 = F1085_10190(loc7);
			if ((EIF_BOOLEAN)(tr1 != NULL)) {
				tr1 = F1085_10189(loc7);
				tb2 = (EIF_BOOLEAN)(tr1 != NULL);
			}
			if (tb2) {
				RTHOOK(4);
				loc5++;
			}
			RTHOOK(5);
			F1085_10193(loc7);
		}
		RTHOOK(6);
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		tp1 = malloc((size_t)(EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		Result = (EIF_POINTER) tp1;
		RTHOOK(7);
		loc1 = RTLNS(eif_new_type(1227, 0x00).id, 1227, _OBJSIZ_0_1_0_1_0_1_1_0_);
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		F1228_10815(RTCW(loc1), Result, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		RTHOOK(8);
		loc8 = F1155_10379(RTCW(arg1));
		for (;;) {
			tb2 = F1085_10192(loc8);
			if (tb2) break;
			RTHOOK(9);
			tb3 = '\0';
			tr1 = F1085_10190(loc8);
			loc9 = tr1;
			if (EIF_TEST(loc9)) {
				tr1 = F1085_10189(loc8);
				loc10 = tr1;
				tb3 = EIF_TEST(loc10);
			}
			if (tb3) {
				RTHOOK(10);
				loc6 = RTLNS(eif_new_type(1532, 0x00).id, 1532, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R11929[Dtype(loc9)-1526])(loc9);
				ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R11929[Dtype(loc10)-1526])(loc10);
				F1531_14996(RTCW(loc6), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
				RTHOOK(11);
				F1533_15110(RTCW(loc6), loc9);
				RTHOOK(12);
				tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '=';
				F1533_15124(RTCW(loc6), tw1);
				RTHOOK(13);
				F1533_15110(RTCW(loc6), loc10);
				RTHOOK(14);
				loc2 = RTLNS(eif_new_type(653, 0x00).id, 653, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F654_9030(RTCW(loc2), loc6);
				RTHOOK(15);
				ti4_1 = F654_9041(RTCW(loc2));
				tp1 = malloc((size_t)(EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				loc3 = (EIF_POINTER) tp1;
				RTHOOK(16);
				tp1 = F654_9037(RTCW(loc2));
				ti4_1 = F654_9041(RTCW(loc2));
				memcpy((void *)loc3, (const void *) tp1, (size_t) (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				RTHOOK(17);
				ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
				F1228_10851(RTCW(loc1), loc3, (EIF_INTEGER_32) (loc4 * ti4_1));
				RTHOOK(18);
				loc4++;
			}
			RTHOOK(19);
			F1085_10193(loc8);
		}
		RTHOOK(20);
		{
			/* INLINED CODE (ANY.default_pointer) */
			tp1 = (EIF_POINTER)  0;
			/* END INLINED CODE */
		}
		tp2 = tp1;
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		F1228_10851(RTCW(loc1), tp2, (EIF_INTEGER_32) (loc4 * ti4_1));
	}
	RTHOOK(21);
	RTLE;
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.terminate_flag_from_status */
EIF_BOOLEAN F1237_11602 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("terminate_flag_from_status", 1236, Current, 0, 1, 15257);
	Result = EIF_TEST(inline_F1237_11602 ((EIF_INTEGER_32) arg1));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.signaled_flag_from_status */
EIF_BOOLEAN F1237_11603 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("signaled_flag_from_status", 1236, Current, 0, 1, 15258);
	Result = EIF_TEST(inline_F1237_11603 ((EIF_INTEGER_32) arg1));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_is_executing */
void F1237_11606 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("set_is_executing", 1236, Current, 0, 1, 15261);
	RTHOOK(1);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) arg1;
	RTHOOK(3);
	RTEE;
}

void EIF_Minit650 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
