/*
 * Code for class GDK_X11
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "gd314.h"
#include <ev_gtk.h>
#include "eif_misc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F334_5846
static void inline_F334_5846 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11
	return gdk_x11_display_error_trap_push ((GdkDisplay *)arg1);
#endif
	;
}
#define INLINE_F334_5846
#endif
#ifndef INLINE_F334_5848
static EIF_POINTER inline_F334_5848 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
		/* Declarations */
	GC gc;									/* handle of newly created GC.  */
	unsigned long valuemask = 0;			/* which values in 'values' to  */
	Window win =  gdk_x11_window_get_xid ((GdkWindow *)arg1);
	Display* display = GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
		/* Define properties/values for the GC.  */
	XGCValues values;						/* initial values for the GC.   */
	unsigned int line_width = 1;			/* line width for the GC.       */
	int line_style = LineSolid;				/* style for lines drawing and  */
	int cap_style = CapButt;				/* style of the line's edje and */
	int join_style = JoinBevel;				/* joined lines.		*/
	values.function = GXcopy;               /* src */
	values.subwindow_mode = ClipByChildren; /* GCSubwindowMode */
	values.line_width = line_width;
	values.fill_style = FillSolid;
	values.arc_mode = ArcPieSlice;
	values.graphics_exposures = False;
	valuemask = GCFunction | GCFillStyle | GCArcMode | GCSubwindowMode | GCGraphicsExposures;
		/* Create the GC object */
	gc = XCreateGC(display, win, valuemask, &values);
	if (gc < 0) {
		fprintf(stderr, "XCreateGC: \n");
	}
	return gc;
#endif
	;
}
#define INLINE_F334_5848
#endif
#ifndef INLINE_F334_5852
static EIF_POINTER inline_F334_5852 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
#endif
	;
}
#define INLINE_F334_5852
#endif
#ifndef INLINE_F334_5867
static EIF_INTEGER_32 inline_F334_5867 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineSolid;
#endif
	;
}
#define INLINE_F334_5867
#endif
#ifndef INLINE_F334_5868
static EIF_INTEGER_32 inline_F334_5868 (void)
{
	#ifdef GDK_WINDOWING_X11
return CapButt;
#endif
	;
}
#define INLINE_F334_5868
#endif
#ifndef INLINE_F334_5869
static EIF_INTEGER_32 inline_F334_5869 (void)
{
	#ifdef GDK_WINDOWING_X11
return JoinBevel;
#endif
	;
}
#define INLINE_F334_5869
#endif
#ifndef INLINE_F334_5856
static void inline_F334_5856 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
				XSetLineAttributes((Display*) arg1, (GC) arg2, 
					(unsigned int) arg3,
      				(int) arg4, (int) arg5, (int) arg6);
				#endif
	;
}
#define INLINE_F334_5856
#endif
#ifndef INLINE_F334_5857
static void inline_F334_5857 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XSetDashes ((Display*) arg1, (GC) arg2, (int) arg3, (char*) arg4, (int) arg5);
#endif
	;
}
#define INLINE_F334_5857
#endif
#ifndef INLINE_F334_5866
static EIF_INTEGER_32 inline_F334_5866 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineOnOffDash;
#endif
	;
}
#define INLINE_F334_5866
#endif
#ifndef INLINE_F334_5853
static EIF_POINTER inline_F334_5853 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) gdk_x11_window_get_xid ((GdkWindow *) arg1);
#endif
	;
}
#define INLINE_F334_5853
#endif
#ifndef INLINE_F334_5854
static void inline_F334_5854 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFunction((Display*) arg1, (GC) arg2, (int) arg3);
#endif
	;
}
#define INLINE_F334_5854
#endif
#ifndef INLINE_F334_5855
static void inline_F334_5855 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetSubwindowMode((Display *)arg1, (GC)arg2, (int)arg3);
#endif
	;
}
#define INLINE_F334_5855
#endif
#ifndef INLINE_F334_5858
static void inline_F334_5858 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFillStyle((Display*)arg1, (GC) arg2, (int)arg3);	
#endif
	;
}
#define INLINE_F334_5858
#endif
#ifndef INLINE_F334_5860
static void inline_F334_5860 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	XFlush((Display*) arg1);
#endif
	;
}
#define INLINE_F334_5860
#endif
#ifndef INLINE_F334_5861
static EIF_INTEGER_32 inline_F334_5861 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillSolid;
#endif
	;
}
#define INLINE_F334_5861
#endif
#ifndef INLINE_F334_5862
static EIF_INTEGER_32 inline_F334_5862 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillTiled;
#endif
	;
}
#define INLINE_F334_5862
#endif
#ifndef INLINE_F334_5871
static EIF_INTEGER_32 inline_F334_5871 (void)
{
	#ifdef GDK_WINDOWING_X11 
return IncludeInferiors;
#endif
	;
}
#define INLINE_F334_5871
#endif
#ifndef INLINE_F334_5874
static void inline_F334_5874 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
/* */
Colormap cmap =  DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1) );
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
/* */
XAllocColor((Display*) arg1, cmap, &color);
XSetBackground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F334_5874
#endif
#ifndef INLINE_F334_5875
static void inline_F334_5875 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
Colormap cmap = DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1));
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
XAllocColor((Display*) arg1, cmap, &color);
XSetForeground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F334_5875
#endif
#ifndef INLINE_F334_5877
static EIF_INTEGER_32 inline_F334_5877 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXand;
#endif
	;
}
#define INLINE_F334_5877
#endif
#ifndef INLINE_F334_5879
static EIF_INTEGER_32 inline_F334_5879 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXcopy;
#endif
	;
}
#define INLINE_F334_5879
#endif
#ifndef INLINE_F334_5882
static EIF_INTEGER_32 inline_F334_5882 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXxor;
#endif
	;
}
#define INLINE_F334_5882
#endif
#ifndef INLINE_F334_5883
static EIF_INTEGER_32 inline_F334_5883 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXor;
#endif
	;
}
#define INLINE_F334_5883
#endif
#ifndef INLINE_F334_5886
static EIF_INTEGER_32 inline_F334_5886 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXinvert;
#endif
	;
}
#define INLINE_F334_5886
#endif
#ifndef INLINE_F334_5892
static void inline_F334_5892 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	#ifdef GDK_WINDOWING_X11 
	Window win = (Window) arg1;
	/*
	 * TODO check Gdkgc-x11 _gdk_x11_gc_flush implementation 
	 * that's used before
	 * for example gdk_x11_draw_segments the usage of
	 * GDK_GC_GET_XGC (gc),
	 * https://github.com/coapp-packages/gtk/blob/master/gdk/x11/gdkdrawable-x11.c
	 */
						
	XDrawLine((Display*) arg2, win, arg3, arg4, arg5, arg6, arg7);
	
#endif
	;
}
#define INLINE_F334_5892
#endif
#ifndef INLINE_F334_5893
static void inline_F334_5893 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XDrawPoint ((Display*) arg2, (Drawable) arg1, arg3, arg4, arg5);
#endif
	;
}
#define INLINE_F334_5893
#endif
#ifndef INLINE_F334_5894
static void inline_F334_5894 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;

						if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);
					else
					    XDrawArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);	
	
				#endif
	;
}
#define INLINE_F334_5894
#endif
#ifndef INLINE_F334_5895
static void inline_F334_5895 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;
					   
					   	if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);
					else
					    XDrawRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);

				#endif
	;
}
#define INLINE_F334_5895
#endif
#ifndef INLINE_F334_5896
static void inline_F334_5896 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					gint i;
					XPoint *tmp_points = g_new (XPoint, arg5);

					for (i=0; i<arg5; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg4)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg4)[i].y;
				    }
				    					
					XDrawLines ((Display*) arg2, win, arg3, tmp_points, arg5, CoordModeOrigin);
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F334_5896
#endif
#ifndef INLINE_F334_5897
static void inline_F334_5897 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					XPoint *tmp_points;
 					gint tmp_npoints, i;


					if (!(arg4) &&
				      ( ((GdkPoint *)arg5)[0].x != ((GdkPoint *)arg5)[arg6-1].x || ((GdkPoint *)arg5)[0].y != ((GdkPoint *)arg5)[arg6-1].y))
				    {
				      tmp_npoints = arg6 + 1;
				      tmp_points = g_new (XPoint, tmp_npoints);
				      tmp_points[arg6].x = ((GdkPoint *)arg5)[0].x;
				      tmp_points[arg6].y = ((GdkPoint *)arg5)[0].y;
				    }
				  	else
				    {
				      tmp_npoints = arg6;
				      tmp_points = g_new (XPoint, tmp_npoints);
				    }

				  	for (i=0; i<arg6; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg5)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg5)[i].y;
				    }


				    if (arg4)
						XFillPolygon ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, Complex, CoordModeOrigin);					
					else	
						XDrawLines ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, CoordModeOrigin);
						
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F334_5897
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {GDK_X11}.gdk_x11_display_error_trap_push */
void F334_5846 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("gdk_x11_display_error_trap_push", 333, Current, 0, 1, 5322);
	inline_F334_5846 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.create_gc */
EIF_POINTER F334_5848 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("create_gc", 333, Current, 0, 1, 5324);
	Result = inline_F334_5848 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_line_attributes_to_solid_style */
void F334_5849 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_solid_style", 333, Current, 0, 3, 5325);
	RTGC;
	RTHOOK(1);
	tp1 = inline_F334_5852(arg1);
	ti4_1 = inline_F334_5867();
	ti4_2 = inline_F334_5868();
	ti4_3 = inline_F334_5869();
	inline_F334_5856(tp1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_line_attributes_to_dashed_style */
void F334_5850 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	EIF_INTEGER_16 loc2 = (EIF_INTEGER_16) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_16 ti2_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_dashed_style", 333, Current, 2, 3, 5326);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F334_5852(arg1);
	RTHOOK(2);
	ti2_1 = eif_bit_shift_left(((EIF_INTEGER_16) 3L),((EIF_INTEGER_32) 8L));
	loc2 = eif_bit_or(((EIF_INTEGER_16) 3L),ti2_1);
	RTHOOK(3);
	inline_F334_5857(loc1, arg2, ((EIF_INTEGER_32) 0L), (EIF_INTEGER_16 *) &(loc2), ((EIF_INTEGER_32) 2L));
	RTHOOK(4);
	ti4_1 = inline_F334_5866();
	ti4_2 = inline_F334_5868();
	ti4_3 = inline_F334_5869();
	inline_F334_5856(loc1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(5);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_display */
EIF_POINTER F334_5852 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_display", 333, Current, 0, 1, 5328);
	Result = inline_F334_5852 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_window */
EIF_POINTER F334_5853 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_window", 333, Current, 0, 1, 5329);
	Result = inline_F334_5853 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_set_function */
void F334_5854 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_function", 333, Current, 0, 3, 5330);
	inline_F334_5854 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_subwindow_mode */
void F334_5855 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_subwindow_mode", 333, Current, 0, 3, 5331);
	inline_F334_5855 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_line_attributes */
void F334_5856 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_line_attributes", 333, Current, 0, 6, 5332);
	inline_F334_5856 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_dashes */
void F334_5857 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_dashes", 333, Current, 0, 5, 5333);
	inline_F334_5857 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_fill_style */
void F334_5858 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_fill_style", 333, Current, 0, 3, 5334);
	inline_F334_5858 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_flush */
void F334_5860 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_flush", 333, Current, 0, 1, 5336);
	inline_F334_5860 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_fill_solid */
EIF_INTEGER_32 F334_5861 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_solid", 333, Current, 0, 0, 5337);
	Result = inline_F334_5861 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_fill_tiled */
EIF_INTEGER_32 F334_5862 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_tiled", 333, Current, 0, 0, 5338);
	Result = inline_F334_5862 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_on_off_dash */
EIF_INTEGER_32 F334_5866 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_on_off_dash", 333, Current, 0, 0, 5342);
	Result = inline_F334_5866 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_solid */
EIF_INTEGER_32 F334_5867 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_solid", 333, Current, 0, 0, 5343);
	Result = inline_F334_5867 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_cap_butt */
EIF_INTEGER_32 F334_5868 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_cap_butt", 333, Current, 0, 0, 5344);
	Result = inline_F334_5868 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_join_bevel */
EIF_INTEGER_32 F334_5869 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_join_bevel", 333, Current, 0, 0, 5345);
	Result = inline_F334_5869 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_subwindow_mode_include_inferiors */
EIF_INTEGER_32 F334_5871 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_subwindow_mode_include_inferiors", 333, Current, 0, 0, 5347);
	Result = inline_F334_5871 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_drawable_background */
void F334_5872 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_background", 333, Current, 1, 5, 5348);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F334_5852(arg1);
	RTHOOK(2);
	inline_F334_5874(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_drawable_foreground */
void F334_5873 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_foreground", 333, Current, 1, 5, 5349);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F334_5852(arg1);
	RTHOOK(2);
	inline_F334_5875(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_background */
void F334_5874 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_background", 333, Current, 0, 5, 5350);
	inline_F334_5874 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_foreground */
void F334_5875 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_foreground", 333, Current, 0, 5, 5351);
	inline_F334_5875 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_function_gxand */
EIF_INTEGER_32 F334_5877 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxand", 333, Current, 0, 0, 5353);
	Result = inline_F334_5877 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxcopy */
EIF_INTEGER_32 F334_5879 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxcopy", 333, Current, 0, 0, 5355);
	Result = inline_F334_5879 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxxor */
EIF_INTEGER_32 F334_5882 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxxor", 333, Current, 0, 0, 5358);
	Result = inline_F334_5882 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxor */
EIF_INTEGER_32 F334_5883 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxor", 333, Current, 0, 0, 5359);
	Result = inline_F334_5883 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxinvert */
EIF_INTEGER_32 F334_5886 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxinvert", 333, Current, 0, 0, 5362);
	Result = inline_F334_5886 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.draw_line */
void F334_5892 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_line", 333, Current, 0, 7, 5368);
	inline_F334_5892 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_point */
void F334_5893 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_point", 333, Current, 0, 5, 5316);
	inline_F334_5893 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_arc */
void F334_5894 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_arc", 333, Current, 0, 10, 5317);
	inline_F334_5894 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8, (EIF_INTEGER_32) arg9, (EIF_INTEGER_32) arg10);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_rectangle */
void F334_5895 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_rectangle", 333, Current, 0, 8, 5318);
	inline_F334_5895 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_lines */
void F334_5896 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_lines", 333, Current, 0, 5, 5319);
	inline_F334_5896 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_polygon */
void F334_5897 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_polygon", 333, Current, 0, 6, 5320);
	inline_F334_5897 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_POINTER) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit314 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
