﻿note
	description: "Main window for this application"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	author	: "Generated by the New Vision2 Application Wizard."
	date	: "$Date$"
	revision: "$Revision$"

class
	MAIN_WINDOW

inherit
	EV_TITLED_WINDOW
		redefine
			create_interface_objects,
			initialize,
			is_in_default_state
		end

	INTERFACE_NAMES
		export
			{NONE} all
		undefine
			default_create, copy
		end

create
	default_create

feature {NONE} -- Initialization

	create_interface_objects
			-- <Precursor>
		do
				-- Create the menu bar.
			build_standard_menu_bar

				-- Create the toolbar.
			build_main_container

				-- Create the status bar.
			build_standard_status_bar

			create data_set.make ("Customers")
		end

	initialize
			-- Build the interface for this window.
		do
			Precursor {EV_TITLED_WINDOW}

				-- Add the menu bar.
			set_menu_bar (standard_menu_bar)

				-- Add main container.
			extend (main_container)

				-- Add the status bar.
			main_container.extend (standard_status_bar)
			main_container.disable_item_expand (standard_status_bar)

				-- Set the title of the window
			set_title (Window_title)

				-- Set the initial size of the window
			set_size (Window_width, Window_height)

				-- Destroy application on closing.
			close_request_actions.extend (agent do if attached (create {EV_ENVIRONMENT}).application as a then a.destroy end end)
				-- Destroy application on selecting "Exit" menu entry.
			file_menu.last.select_actions.extend (agent do if attached (create {EV_ENVIRONMENT}).application as a then a.destroy end end)

				-- Associate "About" dialog with a help menu.
			help_menu.last.select_actions.extend (agent on_about)

				-- Associate actions.
			server_field.key_press_actions.extend (agent process_key)
			populate_button.select_actions.extend (agent populate_grid)
		end

	is_in_default_state: BOOLEAN
			-- Is the window in its default state
			-- (as stated in `initialize')
		do
			Result :=
				width = Window_width and then
				height = Window_height and then
				title.same_string (Window_title)
		end

feature {NONE} -- Menu Implementation

	standard_menu_bar: EV_MENU_BAR
			-- Standard menu bar for this window.

	file_menu: EV_MENU
			-- "File" menu for this window (contains New, Open, Close, Exit...)

	help_menu: EV_MENU
			-- "Help" menu for this window (contains About...)

	build_standard_menu_bar
			-- Create and populate `standard_menu_bar'.
		do
				-- Create the menu bar.
			create standard_menu_bar

				-- Add the "File" menu
			build_file_menu
			standard_menu_bar.extend (file_menu)

				-- Add the "Help" menu
			build_help_menu
			standard_menu_bar.extend (help_menu)
		ensure
			menu_bar_created:
				standard_menu_bar /= Void and then
				not standard_menu_bar.is_empty
		end

	build_file_menu
			-- Create and populate `file_menu'.
		local
			menu_item: EV_MENU_ITEM
		do
			create file_menu.make_with_text (Menu_file_item)

			create menu_item.make_with_text (Menu_file_new_item)
				--| TODO: Add the action associated with "New" here.
			file_menu.extend (menu_item)

			create menu_item.make_with_text (Menu_file_open_item)
				--| TODO: Add the action associated with "Open" here.
			file_menu.extend (menu_item)

			create menu_item.make_with_text (Menu_file_save_item)
				--| TODO: Add the action associated with "Save" here.
			file_menu.extend (menu_item)

			create menu_item.make_with_text (Menu_file_saveas_item)
				--| TODO: Add the action associated with "Save As..." here.
			file_menu.extend (menu_item)

			create menu_item.make_with_text (Menu_file_close_item)
				--| TODO: Add the action associated with "Close" here.
			file_menu.extend (menu_item)

			file_menu.extend (create {EV_MENU_SEPARATOR})

				-- Create the File/Exit menu item and make it call
				-- `{EV_APPLICATION}.destroy' when it is selected.
			create menu_item.make_with_text (Menu_file_exit_item)
			file_menu.extend (menu_item)
		ensure
			file_menu_created: file_menu /= Void and then not file_menu.is_empty
		end

	build_help_menu
			-- Create and populate `help_menu'.
		local
			menu_item: EV_MENU_ITEM
		do
			create help_menu.make_with_text (Menu_help_item)

			create menu_item.make_with_text (Menu_help_contents_item)
				--| TODO: Add the action associated with "Contents and Index" here.
			help_menu.extend (menu_item)

			create menu_item.make_with_text (Menu_help_about_item)
			help_menu.extend (menu_item)
		ensure
			help_menu_created: help_menu /= Void and then not help_menu.is_empty
		end

feature {NONE} -- StatusBar Implementation

	standard_status_bar: EV_STATUS_BAR
			-- Standard status bar for this window

	standard_status_label: EV_LABEL
			-- Label situated in the standard status bar.
			--
			-- Note: Call `standard_status_label.set_text (...)' to change the text
			--       displayed in the status bar.

	build_standard_status_bar
			-- Create and populate the standard toolbar.
		do
				-- Create the status bar.
			create standard_status_bar
			standard_status_bar.set_border_width (2)

				-- Populate the status bar.
			create standard_status_label
			standard_status_label.align_text_left
			standard_status_bar.extend (standard_status_label)
		ensure
			status_bar_created:
				standard_status_bar /= Void and then
				standard_status_label /= Void
		end

feature {NONE} -- About Dialog Implementation

	on_about
			-- Display the About dialog.
		do
			;(create {ABOUT_DIALOG}).show_modal_to_window (Current)
		end

feature {NONE} -- Implementation

	main_container: EV_VERTICAL_BOX
			-- Main container (contains all widgets displayed in this window)

	data_grid: WINFORMS_DATA_GRID
			-- Data grid

	server_field, database_field: EV_TEXT_FIELD

	populate_button: EV_BUTTON
			-- A button to trigger population of the grid.

	build_main_container
			-- Create and populate `main_container'.
		local
			winform_container: EV_WINFORM_CONTAINER
			l_hbox: EV_HORIZONTAL_BOX
			l_label: EV_LABEL
		do
			create main_container

			create l_hbox
			create l_label.make_with_text ("SQL Server: ")
			l_hbox.extend (l_label)
			l_hbox.disable_item_expand (l_label)
			create server_field.make_with_text ("localhost")
			server_field.set_minimum_width (100)
			l_hbox.extend (server_field)
			l_hbox.extend (create {EV_CELL})

			create l_label.make_with_text ("Database: ")
			l_hbox.extend (l_label)
			l_hbox.disable_item_expand (l_label)
			create database_field.make_with_text ("Northwind")
			database_field.set_minimum_width (100)
			l_hbox.extend (database_field)
			l_hbox.extend (create {EV_CELL})

			create populate_button.make_with_text ("Populate grid")
			l_hbox.extend (populate_button)
			l_hbox.disable_item_expand (populate_button)

			l_hbox.set_padding_width (8)
			l_hbox.set_border_width (5)

			main_container.extend (l_hbox)
			main_container.disable_item_expand (l_hbox)

			main_container.extend (create {EV_HORIZONTAL_SEPARATOR})
			main_container.disable_item_expand (main_container.last)

			create winform_container
			create data_grid.make
			data_grid.set_caption_text ("Winform data grid inside a Vision2 container")
			winform_container.extend (data_grid)
			main_container.extend (winform_container)
		ensure
			main_container_created: main_container /= Void
		end

feature {NONE} -- Implementation / Constants

	Window_title: STRING_32 = "ADO Application"
			-- Title of the window.

	Window_width: INTEGER = 400
			-- Initial width for this window.

	Window_height: INTEGER = 400
			-- Initial height for this window.

feature -- Database code

	populate_grid
			-- Populate data grid from DB.
		do
			standard_status_label.set_text ("Populating data grid...")
			if attached (create {EV_ENVIRONMENT}).application as a then
				a.process_events
			end
			do_populate
			data_grid.set_data_binding (data_set, "Suppliers")
			standard_status_label.set_text ("Data grid populated.")
		end

	process_key (a_key: EV_KEY)
			--
		do
			if a_key.code = {EV_KEY_CONSTANTS}.Key_enter then
				populate_grid
			end
		end

feature {NONE} -- Data

	data_set: DATA_DATA_SET
			-- Associated data set of `data_grid'.

	do_populate
		local
			northwind_connection: DATA_SQL_CONNECTION
			suppliers_adapter: DATA_SQL_DATA_ADAPTER
			products_adapter: DATA_SQL_DATA_ADAPTER
			command_on_suppliers: DATA_SQL_COMMAND
			command_on_products: DATA_SQL_COMMAND
			a_mapping: DATA_DATA_TABLE_MAPPING
			connection_string: STRING
		do
				-- create a DATA_SQL_CONNECTION from the given connection string.
				-- Change the data source value to the name of your computer.
			connection_string := "server="
			connection_string.append (server_field.text)
			connection_string.append (";Trusted_Connection=yes;database=")
			connection_string.append (database_field.text)
			create northwind_connection.make (connection_string)

				-- Create a DATA_SQL_DATA_ADAPTER for the Suppliers table.
			create suppliers_adapter.make

				-- A table mapping tells the adapter what to call the table.
			if attached suppliers_adapter.table_mappings as m then
				a_mapping := m.add ("Table", "Suppliers")
			end

			northwind_connection.open
			create command_on_suppliers.make ("SELECT * FROM Suppliers", northwind_connection)

			command_on_suppliers.set_command_type ({DATA_COMMAND_TYPE}.Text)
			suppliers_adapter.set_select_command (command_on_suppliers)

			suppliers_adapter.fill_data_set (data_set).do_nothing

				-- Create a second DATA_SQL_DATA_ADAPTER and DATA_SQL_COMMAND to get
				-- the Products table, a child table of Suppliers.

			create products_adapter.make
			if attached products_adapter.table_mappings as m then
				a_mapping := m.add ("Table", "Products")
			end

			create command_on_products.make ("SELECT * FROM Products", northwind_connection)

			products_adapter.set_select_command (command_on_products)
			products_adapter.fill_data_set (data_set).do_nothing
			northwind_connection.Close

				-- You must create a DATA_DATA_RELATION to link the two tables.
				-- Get the parent and child columns of the two tables.

			if
				attached data_set.tables as t and then
				attached t.item ("Suppliers") as s and then
				attached s.columns as sc and then
				attached t.item ("Products") as p and then
				attached  p.columns as pc and then
				attached data_set.relations as r
			then
				r.add (create {DATA_DATA_RELATION}.make ("suppliers2products", sc.item ("SupplierID"), pc.item ("SupplierID")))
			end
		end

note
	copyright:	"Copyright (c) 1984-2018, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"

end
