note
	description: "[
						Objects that represent an EV_RIBBON_TITLED_WINDOW
						The original version of this class was generated by EiffelRibbon.
																			]"
	generator: "EiffelBuild"
	date: "$Date$"
	revision: "$Revision$"

class
	MAIN_WINDOW

inherit
	EV_RIBBON_TITLED_WINDOW
		redefine
			create_interface_objects,
			initialize,
			application_menu,
			help_button,
			quick_access_toolbar
		end

	EV_SHARED_APPLICATION
		undefine
			default_create, copy
		end


feature {NONE}-- Initialization

	initialize
			-- Initialize `Current'.
		do
			Precursor {EV_RIBBON_TITLED_WINDOW}

				-- Build widget structure.

			set_title ("Ribbon window")

				-- Call `user_initialization'.
			user_initialization
		end

	user_initialization
			-- Called by `initialize'.
			-- Any custom user initialization that
			-- could not be performed in `initialize',
			-- (due to regeneration of implementation class)
			-- can be added here.
		do
			set_size (800, 400)

				-- !!! Attach Ribbon by COM here !!!
			ribbon.init_with_window (Current)
			close_request_actions.extend (agent ev_application.destroy)
			show_actions.extend_kamikaze (agent
									do
										if attached ev_application as l_app then
											l_app.destroy_actions.extend (agent ribbon.destroy)
										end
									end)
			mini_toolbars.extend (mini_toolbar)
			context_menus.extend (context_menu)

			add_recent_items
		end

	add_recent_items
			-- Add recent items to right pane of Application Menu
		local
			l_list: ARRAYED_LIST [EV_RIBBON_APPLICATION_MENU_RECENT_ITEM]
			l_item: EV_RIBBON_APPLICATION_MENU_RECENT_ITEM
		do
			create l_list.make (2)

			create l_item
			l_item.set_label ("Recent item one")
			l_list.extend (l_item)

			create l_item
			l_item.set_label ("Recent item two")
			l_list.extend (l_item)

			application_menu.recent_items.set_recent_items (l_list)
		end

	create_interface_objects
			-- <Precursor>
		do
				-- Initialize before calling Precursor all the attached attributes
				-- from the current class.

				-- Proceed with vision2 objects creation.
			Precursor
			create ribbon.make
			create application_menu.make_with_command_list (<<{COMMAND_NAME_CONSTANTS}.application_menu>>)
			create help_button.make_with_command_list (<<{COMMAND_NAME_CONSTANTS}.help_button>>)
			create quick_access_toolbar.make_with_command_list (<<{COMMAND_NAME_CONSTANTS}.quick_access_toolbar>>)
			create mini_toolbar.make_with_command_list (<<{COMMAND_NAME_CONSTANTS}.mini_toolbar>>)
			create context_menu.make_with_command_list (<<{COMMAND_NAME_CONSTANTS}.context_menu>>)

		end

feature -- Access

	ribbon: RIBBON
			-- Ribbon attached to current
	application_menu: APPLICATION_MENU
			-- Application menu
	help_button: detachable HELP_BUTTON
			-- Help button
	quick_access_toolbar: detachable QUICK_ACCESS_TOOLBAR
			-- Quick access toolbar
	mini_toolbar: MINI_TOOLBAR
			-- Mini toolbar
	context_menu: CONTEXT_MENU
			-- Context popup

end

