﻿note
	description: "Display information about ROC CMS installation."
	date: "$Date$"
	revision: "$Revision$"

class
	CMS_ADMIN_INFO_HANDLER

inherit
	CMS_HANDLER
	WSF_URI_HANDLER

	SHARED_EXECUTION_ENVIRONMENT

create
	make

feature -- Execution

	execute (req: WSF_REQUEST; res: WSF_RESPONSE)
			-- Execute request handler
		local
			r: like new_generic_response
			s: STRING
			ok: BOOLEAN
			l_is_full: BOOLEAN
		do
			if req.is_get_request_method then
				ok := api.has_permission ({CMS_ADMIN_MODULE_ADMINISTRATION}.perm_view_system_info)
					or else has_debug_permission ({CMS_ADMIN_MODULE_ADMINISTRATION}.perm_view_system_info, req)
				if ok then
					r := new_generic_response (req, res)
					create s.make_empty
					r.set_title ("System Information")
					r.add_to_primary_tabs (api.administration_link ("Administration", ""))
					append_system_info_to (s)
					if attached {WSF_STRING} req.query_parameter ("query") as p_query then
						l_is_full := p_query.is_case_insensitive_equal ("full")
						if
							l_is_full
							or p_query.is_case_insensitive_equal ("environment")
							or p_query.is_case_insensitive_equal ("env")
						then
							append_system_environment_to (s)
						end
						if l_is_full or p_query.is_case_insensitive_equal ("request") then
							append_request_info_to (req, s)
						end
					end
					r.set_main_content (s)
					r.execute
				else
					send_access_denied (req, res)
				end
			else
				send_bad_request (req, res)
			end
		end

feature -- Settings

	has_debug_permission (p: READABLE_STRING_8; req: WSF_REQUEST): BOOLEAN
			-- Has debug permission?
			-- Note: see site/config/module/admin/debug.ini
			--| example:
			--|   [debug]
			--|   key=your-debug-private-key
			--|   app[view system info]=yes
		do
			if attached {WSF_STRING} req.query_parameter ("debug") as p_debug then
				if attached api.module_configuration_by_name ({CMS_ADMIN_MODULE}.name, "debug") as cfg then
					if
						attached cfg.utf_8_text_item ("debug.key") as k
					then
						if p_debug.same_string (k) then
							if
								attached cfg.text_table_item ("app") as tb_app and then
								attached tb_app [p] as s and then
								s.same_string ("yes")
							then
								Result := True
							end
						end
					end
				end
			end
		end

feature -- Execution		

	append_system_info_to (s: STRING)
		local
			l_mailer: NOTIFICATION_MAILER
--			l_previous_mailer: NOTIFICATION_MAILER
		do
			s.append ("<ul>")
			across
				api.setup.system_info as v
			loop
				s.append ("<li><strong>"+ html_encoded (@v.key) +":</strong> ")
				s.append (html_encoded (v))
				s.append ("</li>")
			end
			s.append ("<li><strong>Storage:</strong> ")
			s.append (" -&gt; ")
			s.append (html_encoded (api.storage.description))
			s.append ("</li>")

			s.append ("<li><strong>Mailer:</strong> ")
			l_mailer := api.setup.mailer
			from until l_mailer = Void loop
				s.append (" -&gt; ")
--				s.append (l_mailer.generator)
				if attached {NOTIFICATION_CHAIN_MAILER} l_mailer as l_chain_mailer then
					if attached l_chain_mailer.active as l_active then
						s.append (l_active.generator)
					end
					l_mailer := l_chain_mailer.next
				else
					s.append (l_mailer.generator)
					l_mailer := Void
				end
			end
			s.append ("</li>")
			s.append ("</ul>")
		end

	append_request_info_to (req: WSF_REQUEST; s: STRING)
		do
			s.append ("<h3>Request</h3>%N")
			s.append ("<ul>")

			s.append ("<li><strong>is_https:</strong> " + req.is_https.out + "</li>")
			s.append ("<li><strong>server_url:</strong> " + req.server_url + "</li>")
			s.append ("<li><strong>port:</strong> " + req.server_port.out + "</li>")
			s.append ("<li><strong>absolute %"/test%" url:</strong> " + req.absolute_script_url ("/test") + "</li>")
			s.append ("</ul>")

			if api.is_debug then
				s.append ("<h3>Request variables</h3>%N")
				s.append ("<ul>")
				across
					req.meta_variables as ws
				loop
					s.append ("<li><strong>"+ html_encoded (ws.name) +":</strong> ")
					s.append (html_encoded (ws.value))
					s.append ("</li>")
				end
				s.append ("</ul>")
			end
		end

	append_system_environment_to (s: STRING)
		local
--			l_mailer: NOTIFICATION_MAILER
--			l_previous_mailer: NOTIFICATION_MAILER
		do
			s.append ("<h3>Environment</h3>")
			s.append ("<h4>from Setup</h4>")
			if attached api.setup.environment_items as l_site_envs then
				s.append ("<ul>")
				across
					l_site_envs as env
				loop
					s.append ("<li><strong>"+ html_encoded (@env.key) +":</strong> ")
					if attached env as v then
						s.append (html_encoded (v))
					else
						s.append ("")
					end
					s.append ("</li>")
				end
				s.append ("</ul>")
			end
			s.append ("<h4>from Process</h4>")
			if attached execution_environment.starting_environment as l_proc_envs then
				s.append ("<ul>")
				across
					l_proc_envs as env
				loop
					s.append ("<li><strong>"+ html_encoded (@env.key) +":</strong> ")
					s.append (html_encoded (env))
					s.append ("</li>")
				end
				s.append ("</ul>")
			end
		end

end
